import React from 'react';
import { Form, Select, Button } from 'antd';
import { cleanArray } from './utils';
import { getInput } from './libs';

const columnsRest = { style: { width: 135 } };

const formItemColumns = () => {
  console.log('==========');
  return [
    {
      title: '供货价',
      key: 'supplyPrice',
      placeholder: '请先选择二级规格',
      inputType: 'number',
      rest: columnsRest,
    },
    {
      title: '市场价',
      key: 'marketPrice',
      placeholder: '请选择市场价',
      inputType: 'number',
      rest: columnsRest,
    },
    {
      title: '重量(kg)',
      key: 'weight',
      inputType: 'number',
      rest: columnsRest,
      role: [1, 2],
    },
    {
      title: '库存',
      key: 'productStock',
      inputType: 'number',
      rest: columnsRest,
    },
  ];
};

const formItemStyle = {
  style: {
    display: 'inline-block',
    marginRight: 5,
    marginBottom: 0,
  },
};

const createSpecSelect = ({ specId, list, placeholder }) => (
  <Select allowClear style={{ width: 120 }} placeholder={specId?.label || placeholder}>
    {list.map(item => (
      <Select.Option key={item} value={item}>
        {item}
      </Select.Option>
    ))}
  </Select>
);

const createFormItems = (productType = 1, { getFieldDecorator }) => {
  const formItems = formItemColumns()
    .filter(item => !item.role || item?.role.includes(productType))
    .map(item => (
      <Form.Item {...formItemStyle}>
        {getFieldDecorator(`batchItem[${item.key}]`, {})(getInput(item))}
      </Form.Item>
    ));
  return formItems;
};

export const BatchSettings = ({ form, settingTable }) => {
  const { getFieldDecorator, getFieldsValue, getFieldValue } = form;
  const values = getFieldsValue();
  const { firstSpecId, secondSpecId, firstValues = [], secondValues = [] } = values;
  const cleanFirstValues = cleanArray(firstValues);
  const cleanSecondValues = cleanArray(secondValues);
  const renderFormItem = createFormItems(2, { getFieldDecorator });

  return (
    <div>
      <Form.Item {...formItemStyle}>
        {getFieldDecorator('batchItem[batchFirst]', {})(
          createSpecSelect({
            list: cleanFirstValues,
            specId: firstSpecId,
            placeholder: '请先选择一级规格',
          }),
        )}
      </Form.Item>
      <Form.Item {...formItemStyle}>
        {getFieldDecorator('batchItem[batchSecond]', {})(
          createSpecSelect({
            list: cleanSecondValues,
            specId: secondSpecId,
            placeholder: '请先选择二级规格',
          }),
        )}
      </Form.Item>
      {renderFormItem}
      <Form.Item style={{ display: 'inline-block' }}>
        <Button type="primary" onClick={() => settingTable(getFieldValue('batchItem'))}>
          批量设置
        </Button>
      </Form.Item>
    </div>
  );
};
