import React, { useState } from 'react';
import { Table, Form, InputNumber, Input, Popconfirm, Button, notification } from 'antd';
import { getInput } from './libs';
import { cleanArray } from './utils';
import { BatchSettings } from './BatchSettings';

const initData = {
  weight: null,
  productStockWarning: null,
  marketPrice: null,
  supplyPrice: null,
  productStock: null,
  thirdSkuNo: null,
  skuLink: null,
  imageList: [],
};

const createSecondProduct = (secondValues, initItem, secondSpecId, dataSource, callback) => {
  secondValues.forEach(secondItem => {
    const specSecond = { ...initItem };
    if (callback) {
      callback(specSecond);
    }
    specSecond.secondSpecId = secondSpecId.key;
    specSecond.secondSpecValue = secondItem;
    dataSource.push(specSecond);
  });
};

const createProductData = ({ firstValues, secondValues, firstSpecId, secondSpecId }) => {
  const countRowSpan = {};
  const dataSource = [];
  if (firstValues.length) {
    firstValues.forEach((fisrtItem, index) => {
      const specFirst = { ...initData };
      specFirst.firstSpecId = firstSpecId.key;
      specFirst.firstSpecValue = fisrtItem;
      if (secondValues.length) {
        createSecondProduct(secondValues, specFirst, secondSpecId, dataSource, specSecond => {
          if (!countRowSpan[specFirst.firstSpecValue]) {
            countRowSpan[specFirst.firstSpecValue] = true;
            specSecond.rowSpanCount = secondValues.length;
          }
        });
        return;
      }
      dataSource.push(specFirst);
    });
  } else if (secondValues.length) {
    createSecondProduct(secondValues, initData, secondSpecId, dataSource);
  } else {
    dataSource.push(initData);
  }
  return dataSource;
};

const isRepeatProduct = (list, message) => {
  const isRepeat = [...new Set(list)].length !== list.length;
  if (isRepeat) {
    notification.warning({ message });
  }
  return isRepeat;
};

const EditableContext = React.createContext();

const EditableCell = tableProps => {
  const renderCell = form => {
    const { getFieldDecorator } = form;
    const {
      editable,
      dataIndex,
      title,
      inputType,
      record,
      index,
      children,
      rules = [],
      required,
      ...restProps
    } = tableProps;
    console.log(record[dataIndex]);
    return (
      <td {...restProps}>
        <Form.Item style={{ margin: 0 }}>
          {getFieldDecorator(`tableArray[${index}][${dataIndex}]`, {
            rules: [
              {
                required,
                message: `请输入${title}!`,
              },
              ...rules,
            ],
            initialValue: record[dataIndex],
          })(getInput(tableProps))}
        </Form.Item>
      </td>
    );
  };
  return <EditableContext.Consumer>{renderCell}</EditableContext.Consumer>;
};

const ProductInfoColumns = (
  { firstSpecId, secondSpecId, firstValues, secondValues },
  productData,
) => {
  const productColData = [
    {
      title: firstSpecId?.label,
      dataIndex: 'firstSpecValue',
      key: 'firstSpecValue',
      editable: false,
      render: (val, row) => ({
        children: val,
        props: {
          // eslint-disable-next-line no-nested-ternary
          rowSpan: secondValues?.length ? (row.rowSpanCount ? row.rowSpanCount : 0) : true,
        },
      }),
      hidden: !firstValues?.length,
    },
    {
      title: secondSpecId?.label,
      dataIndex: 'secondSpecValue',
      key: 'secondSpecValue',
      editable: false,
      hidden: !secondValues?.length,
    },
    {
      title: '供货价',
      key: 'supplyPrice',
      dataIndex: 'supplyPrice',
      editable: true,
      inputType: 'number',
      required: true,
      rules: [],
    },
    {
      title: '市场价',
      key: 'marketPrice',
      dataIndex: 'marketPrice',
      editable: true,
      inputType: 'number',
      required: true,
    },
    {
      title: '重量(kg)',
      key: 'weight',
      dataIndex: 'weight',
      editable: true,
      inputType: 'number',
      required: true,
    },
    {
      title: '库存',
      dataIndex: 'productStock',
      key: 'productStock',
      editable: true,
      inputType: 'number',
      required: true,
    },
    {
      title: '库存预警',
      dataIndex: 'productStockWarning',
      key: 'productStockWarning',
      editable: true,
      inputType: 'number',
      required: true,
    },
    {
      title: '商品自编码',
      dataIndex: 'thirdSkuNo',
      key: 'thirdSkuNo',
      editable: true,
      inputType: 'input',
      required: true,
    },
    {
      title: '京东链接',
      dataIndex: 'skuLink',
      key: 'skuLink',
      inputType: 'input',
      editable: true,
    },
  ];
  return productData.length ? productColData : [];
};

const createProductColumns = (values, productData) => {
  const columns = ProductInfoColumns(values, productData)
    .map(col => {
      console.log('=================>');
      return {
        ...col,
        onCell: (record, index) => ({
          index,
          record,
          inputType: col.inputType,
          editable: col.editable,
          dataIndex: col.dataIndex,
          title: col.title,
          rules: col.rules,
          required: col.required,
        }),
      };
    })
    .filter(col => !col.hidden);
  return columns;
};

export const GenerateProductInfo = ({ form }) => {
  const [productData, setProductData] = useState([]);
  const [columns, setColumns] = useState([]);
  const components = {
    body: {
      cell: EditableCell,
    },
  };
  const handleAddProduct = () => {
    const values = form.getFieldsValue();
    const { firstValues = [], secondValues = [], firstSpecId, secondSpecId } = values;
    const cleanFirstValues = cleanArray(firstValues); // 清楚空属性
    const cleanSecondValues = cleanArray(secondValues);

    // 校验是否有重复的一级规格
    const fisrtIsRepeat = isRepeatProduct(cleanFirstValues, '一级规格不可重复');
    const secondIsRepeat = isRepeatProduct(cleanSecondValues, '二级规格不可重复');
    if ([fisrtIsRepeat, secondIsRepeat].includes(true)) {
      setProductData([]);
      return;
    }

    const cleanValues = {
      firstValues: cleanFirstValues,
      secondValues: cleanSecondValues,
      firstSpecId,
      secondSpecId,
    };

    const newData = createProductData(cleanValues);
    console.log(newData);
    setProductData(newData);
    form.setFieldsValue({
      tableArray: newData,
    });
    const columnsData = createProductColumns(cleanValues, newData);
    setColumns(columnsData);
  };

  const settingTable = batchItem => {
    const productKey = Object.keys(batchItem);
    console.log(productKey);
    const newData = productData.map(item => {
      productKey.forEach(key => {
        item[key] = batchItem[key] || null;
      });
      return item;
    });
    console.log(newData);
    setProductData(newData);
    form.setFieldsValue({
      tableArray: newData,
    });
  };

  return (
    <EditableContext.Provider value={form}>
      <div style={{ textAlign: 'center' }}>
        <Button onClick={() => handleAddProduct()} type="primary" style={{ marginBottom: 16 }}>
          生成商品信息
        </Button>
      </div>
      <BatchSettings form={form} settingTable={settingTable} />
      <Table
        rowKey="id"
        pagination={false}
        components={components}
        bordered
        dataSource={productData}
        columns={columns}
        rowClassName="editable-row"
      />
    </EditableContext.Provider>
  );
};
