import { Modal, Table, Button, Pagination } from 'antd';
import React, { useState, useEffect } from 'react';
import styles from '../style.less';
import { changeLog } from '../service';

const LogModal = props => {
  const [tableData, setTableData] = useState([]);
  const [pageNo, setPageNo] = useState(1);
  const [pageSize] = useState(20);
  const columns = [
    {
      title: '时间',
      dataIndex: 'createdAt',
      align: 'center',
    },
    {
      title: '变更字段',
      align: 'center',
      dataIndex: 'changeType',
    },
    {
      title: '变更后内容',
      dataIndex: 'afterChangeValue',
      align: 'center',
    },
    {
      title: '变更前内容',
      dataIndex: 'beforeChangeValue',
      align: 'center',
    },
    {
      title: '变更原因',
      dataIndex: 'reason',
      align: 'center',
    },
    {
      title: '操作账号',
      dataIndex: 'operator',
      align: 'center',
    },
  ];
  const handleSearch = async (page = 1) => {
    setPageNo(page);
    const [data] = await changeLog({ id: props.id, pageNo: page, pageSize });
    setTableData(data);
  };
  const onPageChange = page => {
    handleSearch(page);
  };
  useEffect(() => {
    if (!props.id) return;
    handleSearch();
  }, [props.id]);
  const { visible } = props;
  return (
    <Modal title="日志详情" visible={visible} footer={null} onCancel={props.onCancel} width="800px">
      <Table
        dataSource={tableData.records}
        bordered
        columns={columns}
        rowKey={record => record.id}
        pagination={false}
        scroll={{ y: 300 }}
      />
      {tableData.records && (
        <Pagination
          onChange={onPageChange}
          total={tableData.total}
          showTotal={total => `共${total}条`}
          current={pageNo}
          pageSize={pageSize}
          className={styles.pagination}
        />
      )}
      <Button type="primary" onClick={props.onCancel} className={styles.logBtn}>
        关闭
      </Button>
    </Modal>
  );
};

export default LogModal;
