import React from 'react';

import { Radio, Cascader, InputNumber, Input } from 'antd';

export const RadioComponent = ({ productTypeList }) => (
  <Radio.Group>
    {productTypeList.map(item => (
      <Radio key={item.value} value={item.value} disabled={item.disabled}>
        {item.label}
      </Radio>
    ))}
  </Radio.Group>
);

export const CascaderComponent = ({ categoryData }) => (
  <Cascader
    changeOnSelect
    showSearch
    fieldNames={{ label: 'name', value: 'id', children: 'children' }}
    options={categoryData}
  />
);

export const getInput = ({ inputType, title, children, rest = {} }) => {
  let renderElement = null;
  switch (inputType) {
    case 'number':
      renderElement = <InputNumber {...rest} placeholder={`请输入${title}`} />;
      break;
    case 'input':
      renderElement = <Input {...rest} placeholder={`请输入${title}`} />;
      break;
    default:
      renderElement = (
        <span {...rest} className="ant-form-text">
          {children}
        </span>
      );
  }
  return renderElement;
};
