import React, { useState, useRef } from 'react';
import { notification, Button, Modal, Statistic } from 'antd';
import ProTable from '@ant-design/pro-table';
import _ from 'lodash';
import { searchList, apiEnableStore } from './services';
import { stateDesc, weeks } from './data';
import StoreModal from './components/storeModal';

export default () => {
  const [visible, setVisible] = useState(false);
  const [storeInfo, setStoreInfo] = useState({});
  const table = useRef();
  const onEnableState = async ({ id, state }) => {
    const enable = +state === 1 ? 0 : 1;
    const res = await apiEnableStore({ id, state: enable });
    if (res === '0000') {
      notification.success({ message: `已${state ? '禁用' : '启用'}` });
      // eslint-disable-next-line no-unused-expressions
      table.current?.reload?.();
    }
  };
  const onCreate = () => {
    setVisible(true);
  };
  const closeModal = isReload => {
    if (isReload === true) {
      // eslint-disable-next-line no-unused-expressions
      table.current?.reload?.();
    }
    setVisible(false);
  };
  const columns = [
    {
      title: '门店ID',
      dataIndex: 'id',
      hideInSearch: true,
      width: 80,
    },
    {
      title: '门店名称',
      dataIndex: 'name',
      width: 120,
    },
    {
      title: '门店电话',
      dataIndex: 'phone',
      hideInSearch: true,
      width: 120,
    },
    {
      title: '营业时间',
      dataIndex: 'businessHours',
      hideInSearch: true,
      width: 150,
      render: businessHours => (
        <div>
          <div>
            {businessHours.weeks.map(item => (
              <span>{weeks[item]}</span>
            ))}
          </div>
          <div>
            {businessHours.hoursItems.map(item => (
              <div>
                <span>{item.begin}</span>-<span>{item.end}</span>
              </div>
            ))}
          </div>
        </div>
      ),
    },
    {
      title: '地区',
      dataIndex: 'addr',
      width: 200,
      render: (addr, r) => (
        <span>{`${r.provinceName}${r.cityName}${r.countyName}${r.townName || ''}`}</span>
      ),
    },
    {
      title: '详细地址',
      dataIndex: 'address',
      hideInSearch: true,
      width: 150,
    },
    {
      title: '经纬度',
      dataIndex: 'latlng',
      hideInSearch: true,
      width: 120,
      render: (latlng, r) => <span>{`${r.longitude},${r.latitude}`}</span>,
    },
    {
      title: '状态',
      dataIndex: 'state',
      valueEnum: stateDesc,
      hideInSearch: true,
      width: 120,
      // render: state => <span>{`${stateDesc[state]}`}</span>,
    },
    {
      title: '创建时间',
      dataIndex: 'createdAt',
      hideInSearch: true,
      width: 120,
    },
    {
      title: '操作',
      hideInSearch: true,
      dataIndex: 'action',
      width: 100,
      fixed: 'right',
      render: (val, r) => [
        <Button onClick={() => onEnableState(r)} type="primary">
          {+r.state ? '禁用' : '启用'}
        </Button>,
      ],
    },
  ];
  return (
    <div>
      <ProTable
        columns={columns}
        request={params => searchList(params, 1)}
        rowKey={r => r.serviceNo}
        pagination={{
          pagesSize: 20,
        }}
        bordered
        actionRef={table}
        scroll={{ x: '100%' }}
        search={{
          collapsed: false,
          collapseRender: () => null,
        }}
        headerTitle="连锁门店管理"
        toolBarRender={() => [
          <Button key="button" type="primary" onClick={() => onCreate()}>
            新建
          </Button>,
        ]}
      />
      <StoreModal visible={visible} onCancel={closeModal} formData={storeInfo} />
    </div>
  );
};
