import React, { useState, useImperativeHandle, useRef, forwardRef, useEffect } from 'react';
import { Checkbox } from 'antd';
import { CaretRightOutlined, CaretDownOutlined, LoadingOutlined } from '@ant-design/icons';
import debounce from 'lodash/debounce';
import styles from './index.less';

const CustomTree = forwardRef((props, ref) => {
  const { treeData } = props;
  const refNode = useRef(null);

  const onChange = () => {
    props.onChange(treeData.key, !treeData.checked);
  };

  const onVisible = debounce(e => {
    e.stopPropagation();
    props.onVisibleChildren(treeData.key, !treeData.visibleChildren, treeData.children);
  }, 100);

  const renderIcon = () => {
    if (treeData.children && treeData.isLoading) {
      return <LoadingOutlined />;
    }
    if (treeData.isLeaf) {
      return (
        <div onClick={onVisible}>
          {treeData.visibleChildren ? <CaretDownOutlined /> : <CaretRightOutlined />}
        </div>
      );
    }
    return <span />;
  };
  // treeData.children && treeData.isLoading ? (
  //   [<LoadingOutlined />]
  // ) : treeData.isLeaf ? (
  //   [
  //     <div onClick={onVisible}>
  //       {treeData.visibleChildren ? <CaretDownOutlined /> : <CaretRightOutlined />}
  //     </div>,
  //   ]
  // ) : (
  //   <span />
  // );

  return (
    <div className={styles['ccheck-wrapper']}>
      <div className={styles['ccheck-box']} ref={refNode}>
        <div className={styles['ccheck-box--expand']}>{renderIcon()}</div>
        <Checkbox
          onChange={onChange}
          indeterminate={!treeData.checked && treeData.indeterminate}
          checked={treeData.checked}
        >
          {props.label}
          {treeData.value.length > 0 ? `(${treeData.value.length})` : ''}
        </Checkbox>
        {(treeData.visibleChildren && treeData.children && treeData.children.length && (
          <div className={styles['ccheck-box--childrens']}>{props.children}</div>
        )) ||
          ''}
      </div>
    </div>
  );
});

export default CustomTree;
