/* eslint-disable no-unused-expressions */
import React, { useState, useEffect, useRef, forwardRef } from 'react';
import { Row, Col } from 'antd';
import { relativeTimeRounding } from 'moment';
import styles from './index.less';
import CTreeNode from './CTreeNode';
import { deepClone } from '@/utils/utils';

const CustomTree = forwardRef(props => {
  const refNode = useRef();
  const [treeData, setTreeData] = useState([]);

  const updateChildren = (list, isChecked) => {
    list.forEach(item => {
      item.indeterminate = isChecked;
      item.checked = isChecked;
      if (item.children && item.children.length) {
        item.value = isChecked ? item.children.map(c => c.key) : [];
        updateChildren(item.children, isChecked);
      } else {
        item.value = isChecked ? [item.key] : [];
      }
    });
  };

  const updateTreeData = list => {
    list.forEach(node => {
      let cksel = false;
      let cklen = 0;
      const value = [];
      if (node.children && node.children.length) {
        updateTreeData(node.children);
        let indeterminate = false;
        node.children.forEach(item => {
          if (node.checked || item.checked) {
            value.push(item.key);
          }
          item.indeterminate && (indeterminate = true);
        });
        cklen = value.length;
        node.checked = cklen === node.children.length;
        cksel = cklen === node.children.length || indeterminate;
      }
      node.indeterminate = cklen > 0 || cksel;
      node.value = value;
    });
  };

  const changeChecked = (list, ckey, isChecked, pkey) => {
    let key = '';
    list.forEach(node => {
      if (node.key === ckey) {
        node.checked = isChecked;
        if (!isChecked) {
          key = pkey;
        }
        node.children && node.children.length && updateChildren(node.children, isChecked);
      } else if (node.children && node.children.length) {
        if (changeChecked(node.children, ckey, isChecked, node.key) === node.key) {
          node.checked = false;
          key = pkey;
        }
      }
    });
    return key;
  };

  const onChange = (ckey, isChecked) => {
    const datas = [...treeData];
    changeChecked(datas, ckey, isChecked);
    updateTreeData(datas);
    setTreeData(datas);
  };

  const updateVisibleChildren = (list, visible) => {
    list.forEach(item => {
      item.visibleChildren = false;
      item.isLoading = false;
      if (item.children && item.children.length) {
        updateVisibleChildren(item.children, visible);
      }
    });
  };

  const updateVisible = (list, ckey, visible, pkey) => {
    let key = '';
    list.forEach(node => {
      node.isLoading = false;
      if (node.key === ckey) {
        node.visibleChildren = visible;
        key = pkey;
        node.isLeaf = node.children.length > 0;
        updateVisibleChildren(node.children, visible);
      } else if (node.children && node.children.length) {
        node.visibleChildren = false;
        if (updateVisible(node.children, ckey, visible, node.key) === node.key) {
          node.visibleChildren = true;
          key = pkey;
        } else {
          node.visibleChildren = false;
        }
      }
    });
    return key;
  };

  const filterData = arr => {
    const list = [];
    arr.forEach(item => {
      const checked = props.value.some(val => +val[props.valueKey || 'key'] === +item.addrId);
      list.push({
        label: item.addrName,
        key: +item.addrId,
        level: item.addrLevel,
        value: [],
        checked,
        indeterminate: false,
        children: [],
        isLeaf: true,
        isLoading: false,
        // value: props.templateData.list.filter(item => item.)
      });
    });
    return list;
  };

  const appendTreeData = (list, key, children) =>
    list.map(node => {
      if (node.key === key) {
        return {
          ...node,
          children: children.length ? children : undefined,
        };
      }
      if (node.children) {
        return {
          ...node,
          children: appendTreeData(node.children, key, children),
        };
      }
      return node;
    });

  const ChangeVal = (list, key, v, keyName) => {
    list.forEach(node => {
      if (node.key === key) {
        node[keyName] = v;
      } else if (node.children && node.children.length) {
        ChangeVal(node.children, key, v);
      }
    });
  };

  const onVisibleChildren = async (ckey, visible, children) => {
    let arr = [...treeData];
    if (children && !children.length && typeof props.loadData === 'function') {
      ChangeVal(arr, ckey, true, 'isLoading');
      setTreeData(arr);
      const res = await props.loadData({ key: ckey, children });
      if (res && res.length) {
        arr = appendTreeData(arr, ckey, filterData(res));
      }
    }
    updateVisible(arr, ckey, visible);
    setTreeData(arr);
  };

  const renderTreeNodes = data =>
    data &&
    data.map(item => (
      <CTreeNode
        ref={refNode}
        label={item.label}
        onChange={onChange}
        onVisibleChildren={onVisibleChildren}
        key={item.key}
        treeData={item}
      >
        {(item.children && item.children.length && renderTreeNodes(item.children, item)) || ''}
      </CTreeNode>
    ));

  const handleMouseUp = e => {
    const isCur = e.path.some(item => item.id === 'my-custom-tree-box');
    if (!isCur) {
      onVisibleChildren('', false);
    }
  };

  const initTreeData = (arr = [], level) =>
    arr.map(item => {
      const json = {
        value: item.value || [],
        level,
        visibleChildren: false,
        checked: props.value.some(val => val[props.valueKey || 'key'] === item.key),
        indeterminate: false,
        label: item[props.labelName || 'label'],
        key: item[props.keyName || 'key'],
        isLeaf: true,
        isLoading: false,
      };
      if (item.children) {
        json.children = initTreeData(item.children, level + 1);
      }
      return json;
    });

  useEffect(() => {
    const arr = initTreeData(props.treeData, 1);
    setTreeData(arr);
  }, [props.value, props.treeData]);

  useEffect(() => {
    window.addEventListener('mouseup', handleMouseUp);
    return () => {
      window.removeEventListener('mouseup', handleMouseUp);
    };
  }, [treeData]);

  return (
    <div className={styles['tree-box']} id="my-custom-tree-box">
      <Row justify="space-between">
        {treeData.length &&
          treeData.map(item => (
            <Col span={7}>
              <CTreeNode
                ref={refNode}
                label={item.label}
                onChange={onChange}
                onVisibleChildren={onVisibleChildren}
                key={item.key}
                treeData={item}
              >
                {(item.children && item.children.length && (
                  <div className={styles['tree-children-box']}>
                    <div className={styles['tree-children-wrapper']}>
                      {renderTreeNodes(item.children, item) || ''}
                    </div>
                  </div>
                )) ||
                  ''}
              </CTreeNode>
            </Col>
          ))}
      </Row>
    </div>
  );
});
CustomTree.CTreeNode = CTreeNode;

export default CustomTree;
