import React, { useState, useRef } from 'react';
import ProTable from '@ant-design/pro-table';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import { notification, Button, Modal, Image, message } from 'antd';
import { query } from './services';
import style from './style.less';

const ContractView = () => {
  const [visible, setVisible] = useState(false);
  const [url, setUrl] = useState();
  // 查看
  const onLook = ({ contractPdfUrl }) => {
    if (contractPdfUrl) {
      setUrl(contractPdfUrl);
      setVisible(true);
    } else {
      message.error('暂无合同');
    }
  };
  // 下载
  const ondown = ({ contractPdfUrl }) => {
    if (contractPdfUrl) {
      window.open(contractPdfUrl);
    } else {
      message.error('暂无合同');
    }
  };
  const columns = [
    {
      title: '合同名称',
      dataIndex: 'contractName',
      key: 'contractName',
      align: 'center',
    },
    {
      title: '签约时间',
      dataIndex: 'signDate',
      key: 'signDate',
      align: 'center',
      hideInSearch: true,
    },
    {
      title: '合同状态',
      dataIndex: 'state',
      key: 'state',
      align: 'center',
      filters: false,
      valueEnum: {
        0: '失效',
        1: '有效',
      },
    },
    {
      title: '操作',
      dataIndex: 'action',
      width: 200,
      align: 'center',
      hideInSearch: true,
      render: (text, record) => (
        <>
          <Button
            key="edit"
            type="primary"
            onClick={() => onLook(record)}
            style={{ marginRight: '10px' }}
          >
            查看
          </Button>
          <Button key="del" type="primary" onClick={() => ondown(record)}>
            下载
          </Button>
        </>
      ),
    },
  ];
  return (
    <PageHeaderWrapper>
      {!visible && (
        <ProTable
          search={{
            collapsed: false,
            collapseRender: () => null,
          }}
          columns={columns}
          request={params => query({ ...params })}
          rowKey={r => r.appealNo}
          expandIconColumnIndex={10}
          bordered
          toolBarRender={false}
          scroll={{ x: '100%', y: 400 }}
          pagination={false}
        />
      )}
      {visible && (
        <div className={style.contract}>
          <iframe src={url} height="500" width="95%" title="合同"></iframe>
          <Button type="primary" onClick={() => setVisible(false)}>
            取消
          </Button>
        </div>
      )}
    </PageHeaderWrapper>
  );
};
export default ContractView;
