import React, { useState, useEffect } from 'react';
import { Tag, message, Badge } from 'antd';
import { connect } from 'dva';
import groupBy from 'lodash/groupBy';
import moment from 'moment';
import { BellOutlined } from '@ant-design/icons';
import NoticeIcon from '../NoticeIcon';
import styles from './index.less';

const GlobalHeaderRight = props => {
  const { messageReminderComplexRef, unReadCount = 0 } = props;
  const [count, setCount] = useState(0);

  const open = () => {
    messageReminderComplexRef.current.open();
  };

  useEffect(() => {
    setCount(unReadCount);
  }, [unReadCount]);

  return (
    <span className={styles['badge-box']} onClick={open}>
      <Badge count={count} className={styles['badge-box__self']}>
        <BellOutlined className={styles['badge-box__icon']} />
      </Badge>
    </span>
  );
};

export default connect(({ messageReminder }) => ({
  unReadCount: messageReminder.unReadCount,
}))(GlobalHeaderRight);
