/* eslint-disable no-restricted-syntax */
/* eslint-disable guard-for-in */
import React, { useState, useEffect } from 'react';
import { Modal, Timeline, Button } from 'antd';
import styles from '../index.less';

const LogisticsCom = props => {
  const { visible, onCancel, data } = props;
  return (
    <Modal
      destroyOnClose
      title={$t('view.records')}
      visible={visible}
      onCancel={() => onCancel()}
      onOk={() => onCancel()}
      footer={false}
    >
      {data?.length ? (
        <Timeline>
          {data?.map((item, index) => (
            // eslint-disable-next-line react/no-array-index-key
            <Timeline.Item color={index > 0 ? 'gray' : 'blue'} key={index}>
              <p>{item.optDesc}</p>
              <p>{item.optTime}</p>
            </Timeline.Item>
          ))}
        </Timeline>
      ) : (
        $t('no.view.records')
      )}
      <Button type="primary" onClick={props.onCancel} className={styles.logBtn}>{$t('close')}</Button>
    </Modal>
  );
};

export default LogisticsCom;
