import React, { useState, useEffect, forwardRef, useImperativeHandle } from 'react';
import { Modal, Table } from 'antd';
// import { queryOrderDetail } from '../../service';
import { COUPON_CODE_STATUS } from '../../const';
import style from './index.less';

const DetailModal = (props, ref) => {
  const [visible, setVisible] = useState(false);

  const modalProps = {
    visible,
    width: '1000px',
    title: $t('order.details'),
    footer: null,
    onCancel: () => {
      setVisible(false);
    },
  };

  // const getDetail = async orderNo => {
  //   const params = {
  //     orderNo,
  //   };
  //   const res = await queryOrderDetail(params);
  //   console.log(res);
  // };

  /** @module 基本信息 */
  const [baseInfo, setBaseInfo] = useState({});

  /** @module 商品table */
  const [goodData, setGoodData] = useState([]);
  const goodColumns = [
    {
      title: $t('product'),
      dataIndex: 'spuName',
      width: 350,
      render: (value, record) => {
        const { primaryImage, skuSpec, spuId } = record;
        return (
          <div className={style['sku-info']}>
            <img src={primaryImage} width="50px" height="50px" alt="" />
            <div className={style['sku-info__box']}>
              <p className={style['sku-info__box--name']}>{value}</p>
              {/* <p className={style['sku-info__box--spec']}>规格：{skuSpec}</p>
              <p className={style['sku-info__box--id']}>商品id: {spuId}</p> */}
            </div>
          </div>
        );
      },
    },
    {
      title: $t('unit.price'),
      dataIndex: 'supplyPrice',
      width: 150,
    },
    {
      title: $t('quantity'),
      dataIndex: 'count',
      width: 100,
    },
    {
      title: $t('subtotal'),
      dataIndex: 'subTotal',
      width: 150,
      render: (value, record) => {
        const { supplyPrice, count } = record;
        return (supplyPrice * count).toFixed(2);
      },
    },
    {
      title: $t('product.remark'),
      dataIndex: 'remark',
      width: 150,
    },
    {
      title: $t('aftersales.status'),
      width: 150,
      dataIndex: 'afterServiceStatusDesc',
      render: value => value || '-',
    },
  ];

  /** @module 券码 */
  const [couponData, setCouponData] = useState([]);
  const couponColumns = [
    {
      title: $t('voucher.code'),
      width: 150,
      render: (value, record, index) => `${$t('coupon.code')}${index + 1}`,
    },
    {
      title: $t('validity.period'),
      dataIndex: 'useStartTime',
      width: 350,
      render: (value, record) => {
        const { useEndTime } = record;
        return `${value} - ${useEndTime}`;
      },
    },
    {
      title: $t('verification.time'),
      dataIndex: 'useTime',
      width: 200,
      render: value => value || '-',
    },
    {
      title: $t('verifier'),
      dataIndex: 'usedByShopName',
      width: 150,
      render: value => value || '-',
    },
    {
      title: $t('status'),
      dataIndex: 'codeStatus',
      width: 150,
      render: value => COUPON_CODE_STATUS[value],
    },
  ];

  const open = record => {
    console.log(record);
    setVisible(true);
    const {
      skuVos,
      couponCodeVos,
      receiverName,
      receiverMobile,
      fullAddress,
      orderNo,
      orderTime,
      payTime,
    } = record;

    setGoodData(skuVos);
    setCouponData(couponCodeVos);
    setBaseInfo({
      receiverName,
      receiverMobile,
      fullAddress,
      orderNo,
      orderTime,
      payTime,
    });

    // getDetail(orderNo);
  };

  useImperativeHandle(ref, () => ({
    open,
  }));

  return (
    <Modal {...modalProps}>
      <div className={style['order-info']}>
        <div className={style['order-info--item']}>
          <div className={style['order-info--item__title']}>{$t('recipient.info')}</div>
          <ul className={style['order-info--item__ul']}>
            <li>{$t('name')}{baseInfo.receiverName}</li>
            <li>{$t('phone')}{baseInfo.receiverMobile}</li>
            <li>{$t('address')}{baseInfo.fullAddress}</li>
          </ul>
        </div>
        <div className={style['order-info--item']}>
          <div className={style['order-info--item__title']}>{$t('order.info')}</div>
          <ul className={style['order-info--item__ul']}>
            <li>{$t('order.no')}{baseInfo.orderNo}</li>
            <li>{$t('order.time')}{baseInfo.orderTime}</li>
            <li>{$t('payment.time')}{baseInfo.payTime}</li>
          </ul>
        </div>
      </div>

      {/* 商品 */}
      <div className={style['good-table']}>
        <Table
          pagination={false}
          rowKey="orderSkuId"
          bordered
          columns={goodColumns}
          dataSource={goodData}
        ></Table>
      </div>
      {/* 券码 */}
      <div className={style['coupon-table']}>
        <Table pagination={false} bordered columns={couponColumns} dataSource={couponData}></Table>
      </div>
    </Modal>
  );
};

export default forwardRef(DetailModal);
