import { Tag, Badge } from 'antd';
import React from 'react';

export const appealType = {
  1: $t('appealed'),
  0: $t('not.appealed'),
};
export const column = [
  {
    title: $t('order.id'),
    dataIndex: 'orderId',
    width: 200,
    render: (orderId, r) => (
      <div>
        {r.auditTimeOut ? <Tag color="red">{orderId}</Tag> : orderId}
        {<Badge count={r.reminderFlag ? $t('remind') : ''} size="small" />}
        {<Badge count={+r.autoCancelTimeType === 1 ? $t('large.payment') : ''} size="default" />}
      </div>
    ),
  },
  {
    title: $t('receiver.name'),
    dataIndex: 'receiverName',
    width: 200,
  },
  {
    title: $t('receiver.mobile'),
    dataIndex: 'receiverPhone',
    width: 200,
  },
  {
    title: $t('order.creation.time'),
    dataIndex: 'orderTime',
    key: 'orderTime',
    valueType: 'dateRange',
    width: 200,
  },

  {
    title: $t('order.cancel.time'),
    dataIndex: 'applyTime',
    key: 'applyTime',
    valueType: 'dateRange',
    width: 200,
  },

  {
    title: $t('payment.completion.time'),
    dataIndex: 'payFinishTime',
    key: 'payFinishTime',
    // valueType: 'dateRange',
    hideInSearch: true,
    width: 200,
  },

  {
    title: $t('recipient.address'),
    dataIndex: 'receiverAddress',
    width: 200,
    hideInSearch: true,
  },

  {
    title: $t('order.cancellation.status'),
    dataIndex: 'applyAtOrderStatus',
    hideInSearch: true,
    width: 200,
    valueEnum: {
      1: $t('pending.shipment'),
      2: $t('pending.shipping'),
      3: $t('pending.delivery.shipped'),
    },
  },

  {
    title: $t('urge.or.not'),
    dataIndex: 'reminderFlag',
    hideInSearch: true,
    width: 120,
    valueEnum: {
      true: $t('yes'),
      false: $t('no'),
    },
  },
  {
    title: $t('review.status'),
    dataIndex: 'auditStatus',
    hideInSearch: true,
    width: 120,
    valueEnum: {
      1: $t('pending.review'),
      2: $t('reviewed'),
    },
  },
  {
    title: $t('review.result'),
    dataIndex: 'auditResult',
    hideInSearch: true,
    width: 200,
    valueEnum: {
      0: $t('pending'),
      1: $t('agree'),
      2: $t('disagree'),
      3: $t('autoapproved.due.to.timeout'),
    },
  },
  {
    title: $t('rejection.reason'),
    dataIndex: 'refuseReason',
    hideInSearch: true,
    width: 200,
  },
  {
    title: $t('review.timeout'),
    dataIndex: 'auditOverTime',
    hideInSearch: true,
    width: 200,
  },
];
