import { Tag, Badge } from 'antd';
import React from 'react';

export const appealType = {
  1: $t('appealed'),
  0: $t('not.appealed'),
};
export const columnSticData = [
  {
    title: $t('aftersales.type'),
    dataIndex: 'serviceType',
    hideInSearch: true,
    width: 120,
    render: serviceType => {
      if (+serviceType === 1) {
        return <span style={{ color: '#ff1616' }}>{$t('refund.only')}</span>;
      }
      return <span>{$t('return.refund')}</span>;
    },
  },
  {
    title: $t('order.id'),
    dataIndex: 'orderNo',
    hideInTable: true,
    width: 200,
  },
  {
    title: $t('aftersales.id'),
    dataIndex: 'serviceNo',
    width: 300,
    render: (serviceNo, r) => (
      <div>
        {r.timeout ? <Tag color="red">{serviceNo}</Tag> : serviceNo}
        {<Badge count={r.reminderFlag ? $t('remind') : ''} size="default" />}
      </div>
    ),
  },
  {
    title: $t('order.id'),
    dataIndex: 'orderNo',
    hideInSearch: true,
    width: 300,
  },
  {
    title: $t('aftersales.status'),
    dataIndex: 'dealStatus',
    hideInTable: true,
    valueEnum: {
      0: $t('pending.review'),
      10: $t('pending.thirdparty.review'),
      11: $t('thirdparty.review.approved'),
      12: $t('thirdparty.review.rejected'),
      13: $t('cs.approved'),
      14: $t('merchant.under.review'),
      15: $t('merchant.approved'),
      16: $t('merchant.approval.rejected'),
      20: $t('review.rejected'),
      21: $t('appealing'),
      30: $t('pending.return.logistics'),
      40: $t('pending.return'),
      50: $t('return.rejected'),
      60: $t('pending.refund'),
      61: $t('return.processing'),
      70: $t('aftersales.success'),
      99: $t('user.canceled'),
    },
    width: 100,
  },
  {
    title: $t('aftersales.type'),
    dataIndex: 'type',
    hideInTable: true,
    width: 120,
    valueEnum: {
      1: $t('refund.only'),
      2: $t('return.refund'),
    },
  },

  {
    title: $t('receiver.name'),
    dataIndex: 'receiverName',
    width: 200,
  },
  {
    title: $t('receiver.mobile'),
    dataIndex: 'receiverPhone',
    width: 200,
  },
  {
    title: $t('recipient.address'),
    dataIndex: 'receiveAddress',
    width: 200,
    hideInSearch: true,
  },
  {
    title: $t('order.start.time'),
    width: 120,
    dataIndex: 'startDate',
    key: 'startDate',
    valueType: 'date',
    hideInTable: true,
  },
  {
    title: $t('order.end.time'),
    width: 120,
    dataIndex: 'endDate',
    key: 'endDate',
    valueType: 'date',
    hideInTable: true,
  },
  {
    title: $t('aftersales.reason'),
    dataIndex: 'serviceReason',
    hideInSearch: true,
    width: 200,
  },
  {
    title: $t('aftersales.occurrence.time'),
    dataIndex: 'serviceTime',
    hideInSearch: true,
    width: 200,
  },
  {
    title: $t('timeout.period'),
    dataIndex: 'overtime',
    hideInSearch: true,
    width: 200,
  },
  {
    title: $t('urge.or.not'),
    dataIndex: 'reminderFlag',
    hideInSearch: true,
    width: 120,
    valueEnum: {
      true: $t('yes'),
      false: $t('no'),
    },
  },
  {
    title: $t('approve.aftersale'),
    dataIndex: 'isAgree',
    hideInSearch: true,
    width: 120,
  },
  {
    title: $t('rejection.reason'),
    dataIndex: 'refuseReason',
    hideInSearch: true,
    width: 200,
  },
];
export const columnPassAudit = [
  ...columnSticData,
  {
    title: $t('merchant.return.address'),
    dataIndex: 'merchantAddress',
    hideInSearch: true,
    width: 200,
  },
  {
    title: $t('return.logistics'),
    dataIndex: 'expressCompanyName',
    hideInSearch: true,
    width: 150,
  },
  {
    title: $t('return.tracking.number'),
    dataIndex: 'deliveryNo',
    hideInSearch: true,
    width: 200,
  },
  {
    title: $t('aftersales.status'),
    dataIndex: 'serviceStatus',
    hideInSearch: true,
    width: 120,
  },
];
