import { Modal, Input } from 'antd';
import React, { Component } from 'react';

const { TextArea } = Input;

// eslint-disable-next-line react/prefer-stateless-function
class fileModal extends Component {
  state = {
    remarks: '',
  };

  inputChange = ({ target: { value } }) => {
    this.setState({ remarks: value });
  };

  reset = () => {
    this.setState({ remarks: '' });
  };

  render() {
    const { visible } = this.props;
    return (
      <Modal
        title={$t('rejection.reason')}
        visible={visible}
        onOk={() => {
          this.props.submit(this.state.remarks);
        }}
        onCancel={this.props.onCancel}
        width="500px"
      >
        <div>
          <TextArea value={this.state.remarks} rows={4} onChange={this.inputChange} />
        </div>
      </Modal>
    );
  }
}

export default fileModal;
