import React from 'react';
import { Form } from '@ant-design/compatible';
import '@ant-design/compatible/assets/index.css';
import { Modal, Select, Input, notification } from 'antd';
import { updateStatus } from '../services';

const FormItem = Form.Item;
const { Option } = Select;
const layout = {
  labelCol: { span: 6 },
  wrapperCol: { span: 16 },
};
const valueEnum = [
  {
    status: 1,
    text: $t('average'),
  },
  {
    status: 2,
    text: $t('mismatched'),
  },
];

const StatusForm = props => {
  const { visible, formData } = props;
  const { getFieldDecorator } = props.form;

  const resetForm = () => {
    props.form.resetFields();
  };

  const onCancel = () => {
    props.onClose();
    resetForm();
  };
  const handleSubmit = () => {
    props.form.validateFields(async (err, fieldsValue) => {
      if (err) return;
      const params = {
        ...fieldsValue,
        id: formData.id,
      };
      const businessCode = await updateStatus(params);
      if (businessCode === '0000') {
        notification.success({ message: $t('operation.success') });
        resetForm();
        props.onClose('success');
      }
    });
  };

  return (
    <Modal title={$t('manual.reconciliation')} visible={visible} onCancel={() => onCancel()} onOk={handleSubmit}>
      <Form {...layout} name="formData">
        <FormItem label={$t('status')}>
          {getFieldDecorator('status', {
            initialValue: formData.status,
            rules: [
              {
                required: true,
                message: $t('select.status'),
              },
            ],
          })(
            <Select showSearch placeholder="">
              {valueEnum.map(item => (
                <Option value={item.status} key={item.status}>
                  {item.text}
                </Option>
              ))}
            </Select>,
          )}
        </FormItem>
        <FormItem label={$t('remark')}>
          {getFieldDecorator('remarks', {
            initialValue: formData.remarks,
          })(<Input />)}
        </FormItem>
      </Form>
    </Modal>
  );
};

export default Form.create()(StatusForm);
