import React from 'react';
import { Input, Form, InputNumber, Button, notification } from 'antd';
import { isIntegerNotMust, isCheckPriceTwoDecimal } from '@/utils/validator';
import styles from './style.less';

export function column(specArr = []) {
  return [
    {
      title: $t('sku.code'),
      dataIndex: 'id',
      width: 200,
      align: 'center',
    },
    ...specArr,
    {
      title: $t('supply.price'),
      dataIndex: 'supplyPrice',
      width: 150,
      align: 'center',
      render: (_, row, index) => (
        <div>
          <Form.Item
            label=""
            key="supplyPrice"
            name={['data', index, 'supplyPrice']}
            initialValue={row.supplyPrice || 0}
            rules={[
              { required: true, message: $t('enter.supply.price') },
              { validator: isCheckPriceTwoDecimal },
            ]}
          >
            <Input allowClear />
          </Form.Item>
        </div>
      ),
    },
    {
      title: $t('market.price'),
      width: 135,
      align: 'center',
      dataIndex: 'marketPrice',
      render: (_, row, index) => (
        <div>
          <span>{row.marketPrice}</span>
          <div className={styles.hidden}>
            <Form.Item label="" key="id" name={['data', index, 'skuId']} initialValue={row.id}>
              <input />
            </Form.Item>
          </div>
        </div>
      ),
    },
    {
      title: $t('inventory'),
      width: 80,
      dataIndex: 'stock',
      align: 'center',
      render: (_, row, index) => (
        <div>
          <Form.Item
            label=""
            key="stock"
            name={['data', index, 'stock']}
            initialValue={row.stock || 0}
            rules={[{ required: true, message: $t('stock.required') }, { validator: isIntegerNotMust }]}
          >
            <InputNumber min={0} max={500} />
          </Form.Item>
        </div>
      ),
    },
  ];
}

export function columnManage() {
  return [
    {
      title: $t('sku.code'),
      dataIndex: 'skuId',
      width: 200,
      align: 'center',
    },
    {
      title: $t('sku.product.name'),
      align: 'center',
      dataIndex: 'skuName',
    },
    {
      title: $t('market.price'),
      dataIndex: 'marketPrice',
      width: 160,
      align: 'center',
      sorter: (a, b) => a.marketPrice - b.marketPrice,
      render: (_, row) => <div>{(row.marketPrice || 0).toFixed(2)}</div>,
    },
    {
      title: $t('supply.price'),
      dataIndex: 'supplyPrice',
      width: 160,
      align: 'center',
      sorter: (a, b) => a.supplyPrice - b.supplyPrice,
      render: (_, row) => (
        <div>{(row.supplyPrice && (row.supplyPrice || 0).toFixed(2)) || '-'}</div>
      ),
    },
    {
      title: $t('inventory'),
      dataIndex: 'stock',
      width: 160,
      align: 'center',
      render: (_, row) => <div>{row.stock || '-'}</div>,
    },
    {
      title: $t('actions'),
      dataIndex: 'action',
      width: 150,
      align: 'center',
      render: (_, row) => (
        <div className={styles.actionBtn}>
          {this.canEditable && (row.state === 4 || (row.state >= 5 && row.updateState !== 1)) && (
            <Button
              key="edit"
              type="primary"
              size="small"
              className={styles.button}
              onClick={() => {
                this.serviceVisbleChange(row);
              }}
            >{$t('edit')}</Button>
          )}
          <Button
            key="viewP"
            type="primary"
            size="small"
            className={styles.button}
            onClick={() => this.audit(row.skuId)}
          >{$t('preview')}</Button>
        </div>
      ),
    },
  ];
}
