import { Modal, Table, Button, Pagination, Tabs } from 'antd';
import React, { useState, useEffect } from 'react';
import styles from '../style.less';
import { changeLog, productMerchantLog } from '../service';

const LogModal = props => {
  const [tabActiveKey, setTabActiveKey] = useState('0');
  const [tableData, setTableData] = useState([]);
  const [pageNo, setPageNo] = useState(1);
  const [pageSize] = useState(20);
  const [merchantList, setMerchantList] = useState([]);
  const columns = [
    {
      title: $t('time'),
      dataIndex: 'createdAt',
      align: 'center',
    },
    {
      title: $t('changed.field'),
      align: 'center',
      dataIndex: 'changeType',
    },
    {
      title: $t('postchange.content'),
      dataIndex: 'afterChangeValue',
      align: 'center',
    },
    {
      title: $t('prechange.content'),
      dataIndex: 'beforeChangeValue',
      align: 'center',
    },
    {
      title: $t('change.reason'),
      dataIndex: 'reason',
      align: 'center',
    },
    {
      title: $t('operator.account'),
      dataIndex: 'operator',
      align: 'center',
    },
  ];

  const columnsMerchant = [
    {
      title: $t('time'),
      dataIndex: 'createdAt',
      align: 'center',
    },
    {
      title: $t('review.result'),
      align: 'center',
      dataIndex: 'operation',
      render: value => ([5, 6, 7].includes(value) ? $t('review.passed') : $t('reject')),
    },
    {
      title: $t('rejection.reason'),
      dataIndex: 'rejectReason',
      align: 'center',
    },
    {
      title: $t('operator.account'),
      dataIndex: 'createdBy',
      align: 'center',
    },
  ];

  const handleSearch = async (page = 1) => {
    setPageNo(page);
    const { data = {} } = await changeLog({ id: props.id, pageNo: page, pageSize });
    setTableData(data);
  };

  const onPageChange = page => {
    handleSearch(page);
  };

  const getProductMerchantLog = async () => {
    const { data = [] } = await productMerchantLog(props.spuId);
    setMerchantList(data); // merchantList
  };

  const bundleOnTabChange = key => {
    if (key === '1') {
      getProductMerchantLog();
    } else {
      onPageChange(1);
    }
    setTabActiveKey(key);
  };
  const bundleOnCancel = () => {
    setMerchantList([]);
    setTabActiveKey('0');
    props.onCancel();
  };

  useEffect(() => {
    if (!props.id) return;
    // 20221108 临时隐藏商品详情，默认切换到审核详情 by liteng
    // handleSearch();
    bundleOnTabChange('1');
  }, [props.id]);
  const { visible } = props;
  return (
    <Modal title={$t('log.details')} visible={visible} footer={null} onCancel={bundleOnCancel} width="800px">
      <Tabs type="card" onChange={bundleOnTabChange} activeKey={tabActiveKey}>
        {/* 20221108 临时隐藏商品详情 by liteng */}
        {/* <Tabs.TabPane tab="商品详情" key="0">
          <Table
            dataSource={tableData.records}
            bordered
            columns={columns}
            rowKey={record => record.id}
            pagination={false}
            scroll={{ y: 300 }}
          />
          {tableData.records && (
            <Pagination
              onChange={onPageChange}
              total={tableData.total}
              showTotal={total => `共${total}条`}
              current={pageNo}
              pageSize={pageSize}
              className={styles.pagination}
            />
          )}
        </Tabs.TabPane> */}
        <Tabs.TabPane tab={$t('review.details')} key="1">
          <Table
            dataSource={merchantList}
            bordered
            columns={columnsMerchant}
            rowKey={record => record.id}
            pagination={false}
            scroll={{ y: 300 }}
          />
        </Tabs.TabPane>
      </Tabs>
      <Button type="primary" onClick={bundleOnCancel} className={styles.logBtn}>{$t('close')}</Button>
    </Modal>
  );
};

export default LogModal;
