import React from 'react';
import { Modal, Table } from 'antd';

export default props => {
  const { visible, onCancel, dataSource } = props;
  const handleCancel = () => {
    onCancel();
  };
  const columns = [
    {
      title: $t('product.name'),
      width: 400,
      dataIndex: 'skuName',
    },
    {
      title: $t('product.attributes'),
      dataIndex: 'skuAttr',
    },
    {
      title: $t('item.count'),
      dataIndex: 'count',
    },
  ];
  return (
    <Modal title={$t('order.details')} visible={visible} onCancel={handleCancel} footer={null} width={800}>
      <Table dataSource={dataSource} columns={columns} key="skuName" pagination={false} bordered />
    </Modal>
  );
};
