import React from 'react';
import { Form, Row, Col, TimePicker } from 'antd';
import { mealSections } from '../staticData';
import MealCheckbox from './MealCheckbox';

const MealSection = props => (
  <Form.List name="mealTimePeriod">
    {fields => (
      <>
        {Object.keys(mealSections).map((field, i) => (
          <Row key={field} align="baseline">
            <Col span={4}>
              <Form.Item label="" name={[i, 'mealPeriodType']}>
                <MealCheckbox
                  changeType={e => props.onChangeSection(e, props)}
                  meals={props.meals}
                  field={field}
                />
              </Form.Item>
            </Col>
            <Col span={18}>
              <Form.Item
                name={[i, 'time']}
                rules={
                  props.meals[field]
                    ? [
                        { type: 'array', required: true, message: $t('selection.required') },
                        { validator: props.validateMeals, message: $t('time.slots.cannot.overlap') },
                      ]
                    : []
                }
              >
                <TimePicker.RangePicker format="HH:mm" minuteStep={30} />
              </Form.Item>
            </Col>
          </Row>
        ))}
      </>
    )}
  </Form.List>
);

export default MealSection;
