import React, { useState, useEffect, forwardRef, useRef, useImperativeHandle } from 'react';
import { Button, Modal, Radio, Form, InputNumber, Switch } from 'antd';
import styles from '../common.less';
import { ENUM_SET_REPERTORY } from '../config';

const AddRepertoryModal = (props, ref) => {
  const [confirmLoading, setConfirmLoading] = useState(false);
  const [modalText, setModalText] = useState('Content of the modal');
  const [openRepertory, setOpenRepertory] = useState(false);

  // const {
  //   open,
  //   setOpen,
  // } = props;
  useImperativeHandle(ref, () => ({
    // changeVal 就是暴露给父组件的方法
    setOpenRepertory: newVal => {
      setOpenRepertory(newVal);
    },
  }));
  const onChange3 = () => {};

  const handleOk = () => {
    setModalText('The modal will be closed after two seconds');
    setConfirmLoading(true);
    setTimeout(() => {
      setOpenRepertory(false);
      setConfirmLoading(false);
    }, 2000);
  };

  const handleCancel = () => {
    console.log('Clicked cancel button');
    setOpenRepertory(false);
  };
  useEffect(() => {
    console.log('open', openRepertory);
  }, [openRepertory]);
  return (
    <>
      {openRepertory && (
        <Modal
          title="修改库存"
          visible={openRepertory}
          onOk={handleOk}
          confirmLoading={confirmLoading}
          onCancel={handleCancel}
        >
          <Form>
            <Form.Item className={styles.itemInline}>
              <Form.Item
                name="receptionVolume"
                label="剩余库存"
                style={{
                  display: 'flex',
                  marginRight: '8px',
                }}
                rules={[{ required: true, message: '请填写剩余库存' }]}
              >
                <InputNumber
                  min={1}
                  style={{ width: 200, display: 'inline-block' }}
                  placeholder="请输入"
                />
              </Form.Item>
              <Form.Item name="limitPurchase" style={{ width: 200, display: 'inline-block' }}>
                <Radio.Group options={ENUM_SET_REPERTORY} onChange={onChange3} value={1} />
              </Form.Item>
            </Form.Item>
            <Form.Item
              name="receptionVolume"
              label="最大库存"
              rules={[{ required: true, message: '请填写最大库存' }]}
            >
              <InputNumber min={1} style={{ width: 200 }} placeholder="请输入" />
            </Form.Item>
            <Form.Item name="receptionVolume" label="自动补足">
              <Switch
                checkedChildren="开启"
                unCheckedChildren="关闭"
                defaultChecked
                onChange={onChange3}
              />
            </Form.Item>
            <div className={styles.textStyle}>修改成功后，原库存将被替换，请谨慎操作！</div>
          </Form>
        </Modal>
      )}
    </>
  );
};

export default forwardRef(AddRepertoryModal);
