import React, { useState, useEffect, forwardRef, useRef, useImperativeHandle } from 'react';
import { Button, Modal } from 'antd';


const AddMenusModal = (props, ref) => {
  const [confirmLoading, setConfirmLoading] = useState(false);
  const [modalText, setModalText] = useState('Content of the modal');
  const [open, setOpen] = useState(false);


  // const {
  //   open,
  //   setOpen,
  // } = props;
  useImperativeHandle(ref, () => ({
    // changeVal 就是暴露给父组件的方法
    setOpen: newVal => {
      setOpen(newVal)
    },
}));
  const handleOk = () => {
    setModalText('The modal will be closed after two seconds');
    setConfirmLoading(true);
    setTimeout(() => {
      setOpen(false);
      setConfirmLoading(false);
    }, 2000);
  };

  const handleCancel = () => {
    console.log('Clicked cancel button');
    setOpen(false);
  };
useEffect(() => {
    console.log('open', open);
}, [open])
  return (
    <>
     {open && <Modal
        title="Title"
        visible={open}
        onOk={handleOk}
        confirmLoading={confirmLoading}
        onCancel={handleCancel}
      >
        <p>{modalText}</p>
      </Modal>}
    </>
  );
};


export default forwardRef(AddMenusModal);
