import request from '@/utils/request';
import config from '../../../config/env.config';
import _ from 'lodash';

// 分页查询所有数据
const { querysApi } = config;

export async function query(params) {
  const queryParams = {
    pageSize: params.pageSize || 10,
    pageIndex: params.current || 1,
    createStart: params?.dateTimeRange?.[0],
    createEnd: params?.dateTimeRange?.[1],
    settleState: params?.settleState,
    settleBatchNo: params?.settleBatchNo,
    isCreatePaymentBill: params?.isCreatePaymentBill,
    payBatchNo: params?.payBatchNo,
  };
  const { data } = await request.post('/selfSettleBill/merchant/pageQuery', {
    prefix: querysApi,
    data: _.omitBy(queryParams, v => !v),
  });

  return {
    data: data?.records || [],
    total: data.total || 1,
  };
}
// 生成付款单
export async function selfPaymentBill(params) {
  return request.post('/selfPaymentBill/merchant/generate/paymentBill', {
    prefix: querysApi,
    data: params,
  });
}
