import React from 'react';
import { Form, InputNumber, Row, Col } from 'antd';
import style from '../style/info.less';
import { validateRequired, isCheckPriceTwoDecimal } from '@/utils/validator';

const MealLimit = props => (
  <Form.Item
    label={`${props.label}限额`}
    name={props.name}
    value={props.value}
    rules={[
      { validator: validateRequired, message: `请输入${props.label}限额` },
      { validator: isCheckPriceTwoDecimal, message: '请输入正确的价格' },
    ]}
  >
    <InputNumber addonAfter="元" max={999.99} />
  </Form.Item>
);

export default MealLimit;
