import React from 'react';
import { Form, Row, Col } from 'antd';
import { mealType, mealSections } from '../staticData';
import MealLimit from './MealLimit';

/**
 * 渲染 企业单笔消费限额 二维表单项目
 */
const MealLimitsFormList = (meals, selectedMealTypes) => (
  <Form.List name="mealLimit" key="mealLimit">
    {mealLimitsFields => (
      <>
        {Object.keys(meals).map(meal => (
          <Form.Item
            key={`${mealSections[meal]}`}
            label={`${mealSections[meal]}订单`}
            required
            labelCol={{ span: 4 }}
            wrapperCol={{ span: 20 }}
          >
            <Form.List
              name={`limit${meal}`}
              key={`${meal}limit`}
              required
              wrapperCol={{ span: 21 }}
            >
              {mealLimitsFieldsList => (
                <Row key={`row${meal}`}>
                  {selectedMealTypes.map((t, i) => (
                    <Col span={7} offset={i ? 1 : 0} key={t}>
                      <MealLimit value={t} label={mealType[t]} name={`${t}`} />
                    </Col>
                  ))}
                </Row>
              )}
            </Form.List>
          </Form.Item>
        ))}
      </>
    )}
  </Form.List>
);

export default MealLimitsFormList;
