import { Form } from '@ant-design/compatible';
import '@ant-design/compatible/assets/index.css';
import { Card, Pagination, Table, notification, Drawer, Spin } from 'antd';
import React, { Component } from 'react';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import { connect } from 'dva';
import { sortBy } from 'lodash';
import styles from './style.less';
import LocalStroage from '@/utils/localStorage';
import configApi from '../../../config/env.config';
import UpdateStock from './UpdateStock';
import { spuDetail, categoryList, getVirtualCategory, getTemplateList } from './service';
import LogModal from './LogModal';
import CreateModal from './createModal';
import { column, JDSHOPID } from './staticdata';
import SearchForm from './SearchForm';
import TempleatModal from './TempleatModal';

@connect(({ goodsManage }) => ({
  goodsManage,
}))
class goodsManage extends Component {
  state = {
    pageNo: 1,
    loading: false,
    treeData: [],
    virtualTreeData: [],
    pageSize: 20,
    priceInfo: {},
    logVisible: false,
    previewVisible: false,
    createVisible: false, // 新增or编辑普通商品modal
    updateStockVisible: false,
    initData: {},
    createloading: false,
    templeatModalVisible: false,
    selectedRowKeys: [],
    isAll: 0,
    templateList: [],
  };

  currentLog = null;

  supplierId = null;

  shopList = [];

  componentDidMount() {
    this.props.goodsManage.tableData = {};
    this.categoryList();
    this.getVirtualCategory();
  }

  handleSearch = page => {
    const currentPage = this.state.pageNo;
    this.setState(
      {
        pageNo: page || currentPage,
        loading: true,
      },
      () => {
        const { dispatch } = this.props;
        const { pageSize, pageNo } = this.state;
        dispatch({
          type: 'goodsManage/getList',
          payload: {
            pageNo,
            pageSize,
            ...this.searchForm.getFieldsValue(),
          },
        }).finally(() => {
          this.setState({
            loading: false,
          });
        });
      },
    );
  };

  onPageChange = page => {
    this.handleSearch(page);
  };

  onPageSizeChange = (current, size) => {
    this.setState(
      {
        pageSize: size,
      },
      () => this.handleSearch(),
    );
  };

  onReset = () => {
    this.setState({
      pageNo: 1,
      pageSize: 20,
      selectedRowKeys: [],
    });
    this.handleSearch();
  };

  onUpdateInfo = async ({ spuId, productType }) => {
    this.setState({
      createloading: true,
    });
    const { data, msg } = await spuDetail({ id: spuId });
    if (data) {
      data.pageProductType = productType;
      data.categoryId = data.thirdCategoryId;
      data.firstSpecId = data.skuList[0].firstSpecId;
      data.secondSpecId = data.skuList[0].secondSpecId;
      data.firstSpecName = data.skuList[0].firstSpec;
      data.secondSpecName = data.skuList[0].secondSpec;
      data.firstSpecList = [];
      data.secondSpecList = [];
      data.colorKeys = [];
      data.carouseList.forEach(i => {
        if (i.specValue) {
          data.colorKeys.push(i.specValue);
        }
      });
      data.skuList.forEach(i => {
        if (data.firstSpecList.indexOf(i.firstSpecValue) === -1) {
          data.firstSpecList.push(`${i.firstSpecValue}`);
        }
        if (i.secondSpecValue && data.secondSpecList.indexOf(i.secondSpecValue) === -1) {
          data.secondSpecList.push(i.secondSpecValue);
        }
      });

      data.imageList = [];
      data.carouseList.forEach(i => {
        data.imageList[`${i.specValue}`] = i.skuSpecImageList || [];
      });
      data.editData = sortBy(data.skuList, item => item.firstSpecValue);
      this.setState({
        initData: data,
        createVisible: true,
        createloading: false,
      });
    } else {
      this.setState({
        createloading: false,
      });
      notification.warning({
        message: msg,
      });
    }
  };

  onLoad = error => {
    if (!error) {
      notification.success({ message: '操作成功' });
      this.setState({
        selectedRowKeys: [],
      });
      this.handleSearch();
    }
  };

  viewLog = async rows => {
    this.currentLog = rows;
    this.setState({
      logVisible: true,
    });
  };

  audit = skuId => {
    this.setState({
      previewVisible: true,
      src: `${configApi.prologueDomain}/goods/${skuId}?h=0&token=${LocalStroage.get(
        'token',
      )}&hideReport=1&time=${Date.now()}`,
    });
  };

  setArea = async isAll => {
    if (!this.state.selectedRowKeys.length && !isAll) {
      notification.error({ message: '请选择商品' });
      return;
    }
    const data = await getTemplateList();
    if (data.code === '0000' && data.data.length) {
      this.setState({
        templeatModalVisible: true,
        isAll,
        templateList: data.data,
      });
    } else {
      notification.error({ message: '暂无模板数据,请先添加模板' });
    }
  };

  filterShopList = (list = [], isEdit) =>
    list.filter(item => isEdit || !JDSHOPID.includes(item.id));

  openModal = (
    {
      skuId,
      supplyPrice,
      marketPrice,
      salePrice,
      marketableStock,
      supplierId,
      stock,
      productStock,
    },
    isStock,
  ) => {
    let visible = {};
    if (isStock) {
      visible = { updateStockVisible: true };
    }
    this.setState({
      ...visible,
      priceInfo: {
        id: skuId,
        stock,
        productStock,
        marketableStock,
        supplyPrice,
        marketPrice,
        salePrice,
        supplierId,
      },
    });
  };

  cancel = query => {
    this.setState({ updateStockVisible: false });
    if (query) {
      this.handleSearch();
    }
  };

  categoryList = async () => {
    try {
      const { data: treeData } = await categoryList();
      if (!treeData) return;
      this.setState({ treeData });
    } catch (e) {
      console.log(e);
    }
  };

  getVirtualCategory = async () => {
    try {
      const { data: virtualTreeData } = await getVirtualCategory();
      if (!virtualTreeData) return;
      this.setState({ virtualTreeData });
    } catch (e) {
      console.log(e);
    }
  };

  onSelectChange = selectedRowKeys => {
    this.setState({
      selectedRowKeys,
    });
  };

  render() {
    const {
      goodsManage: { tableData = {} },
    } = this.props;

    const rowSelection = {
      selectedRowKeys: this.state.selectedRowKeys,
      onChange: this.onSelectChange,
    };
    const { pageNo, pageSize, selectedRowKeys } = this.state;
    return (
      <PageHeaderWrapper>
        <Spin spinning={this.state.createloading}>
          <Card>
            <SearchForm
              handleSearch={this.handleSearch}
              onReset={this.onReset}
              onLoad={this.onLoad}
              onRef={ref => {
                this.searchForm = ref;
              }}
              treeData={this.state.treeData}
              shopList={this.shopList}
              addSpu={() => this.setState({ createVisible: true, initData: {} })}
              setArea={isALL => this.setArea(isALL)}
            />
          </Card>
          <Spin spinning={this.state.loading}>
            <Table
              dataSource={tableData?.records}
              bordered
              columns={column.call(this)}
              rowKey={record => record.skuId}
              pagination={false}
              className={styles.tabletop}
              scroll={{ x: '100%', y: 500 }}
              rowSelection={rowSelection}
            />
          </Spin>
          <br />
          {tableData && (
            <Pagination
              style={{ marginBottom: 10 }}
              onChange={this.onPageChange}
              total={tableData.total}
              showTotal={total => `共${total}条`}
              current={pageNo}
              pageSize={pageSize}
              showSizeChanger
              onShowSizeChange={this.onPageSizeChange}
            />
          )}

          <LogModal
            visible={this.state.logVisible}
            spuId={this.currentLog?.spuId}
            id={this.currentLog?.skuId}
            onCancel={() => {
              this.currentLog = null;
              this.setState({ logVisible: false });
            }}
          />
          <Drawer
            visible={this.state.previewVisible}
            width="450"
            onClose={() => {
              this.setState({ previewVisible: false });
            }}
            title="商品预览"
            bodyStyle={{ height: '90%' }}
          >
            <iframe
              src={this.state.src}
              frameBorder="0"
              height="100%"
              width="375"
              title="商品预览"
            ></iframe>
          </Drawer>
          <CreateModal
            initData={this.state.initData}
            visible={this.state.createVisible}
            onCancel={() => {
              this.setState({ createVisible: false, initData: {} });
            }}
            query={() => this.handleSearch()}
            shopList={this.filterShopList(this.shopList, Object.keys(this.state.initData).length)}
            treeData={this.state.treeData}
            virtualTreeData={this.state.virtualTreeData}
          ></CreateModal>

          <UpdateStock
            visible={this.state.updateStockVisible}
            info={this.state.priceInfo}
            onCancel={this.cancel}
          />
          <TempleatModal
            visible={this.state.templeatModalVisible}
            selectedRowKeys={this.state.selectedRowKeys}
            onCancel={() => {
              this.setState({ templeatModalVisible: false, selectedRowKeys: [] });
              this.handleSearch();
            }}
            isALL={this.state.isAll}
            templateList={this.state.templateList}
          />
        </Spin>
      </PageHeaderWrapper>
    );
  }
}

export default Form.create()(goodsManage);
