import React from 'react';
import { Form } from '@ant-design/compatible';
import '@ant-design/compatible/assets/index.css';
import { Modal, Input, Cascader, notification } from 'antd';
import { shopAudit } from '../service';

const FormItem = Form.Item;
const { TextArea } = Input;
const AuditModal = props => {
  const {
    visible,
    onCancel,
    form: { getFieldDecorator, getFieldValue, validateFields, resetFields },
    formData = {},
  } = props;

  const handleCancel = isSuccess => {
    resetFields();
    onCancel(isSuccess);
  };
  const treeData = [
    {
      label: '同意',
      value: true,
    },
    {
      label: '不同意',
      value: false,
      children: [
        {
          label: '订单已发货',
          value: 10,
        },
        {
          label: '已与客户沟通继续发货',
          value: 20,
        },
        {
          label: '其他',
          value: 30,
        },
      ],
    },
  ];
  const handleOk = () => {
    validateFields(async (error, fieldsValue) => {
      if (!error) {
        const { approve } = fieldsValue;
        const data = await shopAudit({
          ...fieldsValue,
          refuseReasonCode: approve?.[1],
          approve: approve?.[0],
          serviceNo: formData?.serviceNo,
        });
        if (data.businessCode === '0000') {
          notification.success({ message: approve?.[0] ? '审核成功' : '审核拒绝提交成功' });
          handleCancel(true);
        }
      }
    });
  };

  const layout = {
    labelCol: { span: 6 },
    wrapperCol: { span: 16 },
  };
  const approve = getFieldValue('approve');
  const isRefuse = () => approve && approve[0] !== 1;
  return (
    <Modal
      title="售后操作确认"
      visible={visible}
      onOk={() => handleOk()}
      onCancel={() => handleCancel()}
    >
      <Form {...layout} name="formData">
        <FormItem label="审核结果">
          {getFieldDecorator('approve')(
            <Cascader
              allowClear
              showSearch
              style={{ width: '315px' }}
              dropdownStyle={{ maxHeight: 400, overflow: 'auto' }}
              options={treeData}
              placeholder="请选择"
            />,
          )}
        </FormItem>
        {isRefuse() && approve[1] === 30 && (
          <FormItem label="拒绝原因">
            {getFieldDecorator('refuseReasonRemark', {
              initialValue: formData.refuseDesc,
              rules: [
                {
                  required: true,
                  message: '请填写拒绝原因!',
                },
              ],
            })(
              <TextArea
                placeholder="请填写拒绝原因"
                allowClear
                autoSize={{ minRows: 3, maxRows: 6 }}
              />,
            )}
          </FormItem>
        )}
      </Form>
    </Modal>
  );
};

export default Form.create()(AuditModal);
