import React, { useRef, forwardRef } from 'react';
import { Form, Input, Row, Col, Button } from 'antd';
import { getSMSCaptcha } from '@/services/login';
import { getDefaultRule } from '@/utils/validator';
import styles from '../../style.less';

const FormItem = Form.Item;
const LoginSMS = forwardRef((props, ref) => {
  const refPhone = useRef();

  const onFinish = ({ phone, code }) => {
    const { dispatch } = props;
    dispatch({
      type: 'login/login',
      payload: { username: phone, password: code, tenantId: 560761, source: 1 },
    });
  };

  const onGetCaptcha = async () => {
    console.log('this.refPhone.current :>> ', refPhone);
    // await getSMSCaptcha({
    //   phone: '',
    //   tenantId: 560761,
    //   source: 1,
    // });
  };

  return (
    <Form onFinish={onFinish} name="horizontal_login" layout="inline">
      <FormItem label="" ref={refPhone} name="phone" rules={[getDefaultRule('请输入手机号!')]}>
        <Input
          placeholder="请输入手机号"
          prefix="+86"
          maxLength={11}
          className={styles.txt}
          allowClear
        />
      </FormItem>
      <FormItem label="" name="code" rules={[getDefaultRule('请输入验证码!')]}>
        <Row>
          <Col span={16}>
            <Input placeholder="请输入验证码" maxLength={6} className={styles.txt} allowClear />
          </Col>
          <Col span={8}>
            <Button type="primary" onClick={onGetCaptcha} className={styles.btnCode}>
              获取验证码
            </Button>
          </Col>
        </Row>
      </FormItem>
      <Button
        type="primary"
        htmlType="submit"
        size="large"
        className={styles.btnSubmit}
        loading={props.submitting}
      >
        登录
      </Button>
    </Form>
  );
});

export default LoginSMS;
