import { Alert, Tabs, Form, Input, Row, Col, Button } from 'antd';
import React, { Component } from 'react';
import { connect } from 'dva';
// import { getSMSCaptcha } from '@/services/login';
import LoginComponents from './components/Login';
// import { getDefaultRule } from '@/utils/validator';
import styles from './style.less';
import LoginSMS from './components/Login/LoginSms';

const { UserName, Password, Submit } = LoginComponents;
// const FormItem = Form.Item;

@connect(({ login, loading }) => ({
  userLogin: login,
  submitting: loading.effects['login/login'],
}))
class Login extends Component {
  loginForm = undefined;

  handleSubmit = (err, values) => {
    if (!err) {
      const { dispatch } = this.props;
      dispatch({
        type: 'login/login',
        payload: { ...values, tenantId: 560761, source: 1 },
      });
    }
  };

  renderMessage = content => (
    <Alert
      style={{
        marginBottom: 24,
      }}
      message={content}
      type="error"
      showIcon
    />
  );

  render() {
    const { userLogin, submitting } = this.props;
    const { status } = userLogin;
    return (
      <div className={styles.main}>
        <Tabs defaultActiveKey="1" destroyInactiveTabPane>
          <Tabs.TabPane tab="账号密码登录" key="1">
            <LoginComponents
              onSubmit={this.handleSubmit}
              onCreate={form => {
                this.loginForm = form;
              }}
            >
              {status === 'error' &&
                !submitting &&
                this.renderMessage('账户或密码错误（admin/ant.design）')}
              <UserName
                name="username"
                placeholder={`${'用户名'}`}
                rules={[
                  {
                    required: true,
                    message: '请输入用户名!',
                  },
                ]}
              />
              <Password
                name="password"
                placeholder={`${'密码'}`}
                rules={[
                  {
                    required: true,
                    message: '请输入密码！',
                  },
                ]}
                onPressEnter={e => {
                  e.preventDefault();

                  if (this.loginForm) {
                    this.loginForm.validateFields(this.handleSubmit);
                  }
                }}
              />

              <Submit loading={submitting}>登录</Submit>
            </LoginComponents>
          </Tabs.TabPane>
          <Tabs.TabPane tab="手机号登录" key="2">
            <LoginSMS loading={submitting} dispatch={this.props.dispatch} />
          </Tabs.TabPane>
        </Tabs>
      </div>
    );
  }
}

export default Login;
