import React, { useState } from 'react';
import { Map, Marker, ZoomControl, CityListControl } from 'react-bmapgl';
import { Modal, Input } from 'antd';

export default props => {
  const { visible, onSetPoint, onCancel, lngLat } = props;
  const defaultLnglat = { lng: 116.404449, lat: 39.914889 };
  if (lngLat) {
    defaultLnglat.lng = lngLat.lng;
    defaultLnglat.lat = lngLat.lat;
  }

  const [lnglatPoint, setLnglatPoint] = useState(defaultLnglat);
  const [lnglatText, setLnglatText] = useState(`${defaultLnglat.lng},${defaultLnglat.lat}`);

  const handleOk = () => {
    onSetPoint(lnglatPoint);
    onCancel(true);
  };

  const handleCancle = () => onCancel(true);

  const onGetPoint = e => {
    setLnglatPoint({
      lng: e.latlng.lng,
      lat: e.latlng.lat,
    });
    setLnglatText(`${e.latlng.lng},${e.latlng.lat}`);
  };

  return (
    <Modal
      title="门店信息"
      visible={visible}
      width="800px"
      onOk={() => handleOk()}
      onCancel={() => handleCancle()}
    >
      <div style={{ marginBottom: '20px' }}>
        <Input value={lnglatText} placeholder="点击地图选择经纬度" />
      </div>
      <div style={{ width: '100%', height: '360px' }}>
        <Map
          center={lnglatPoint}
          enableScrollWheelZoom
          enableDoubleClickZoom
          coordType="gcj02"
          onClick={e => onGetPoint(e)}
          zoom={15}
        >
          <Marker
            position={lnglatPoint}
            Icon
            coordType="gcj02"
            autoViewport
            viewportOptions={{
              zoomFactor: -12,
            }}
          />
          <CityListControl />
          <ZoomControl />
        </Map>
      </div>
    </Modal>
  );
};
