// import fileSaver from 'file-saver';
import request from '@/utils/request';
import config from '../../../config/env.config';
import { stringify } from 'qs';
import _ from 'lodash';

const { goodsApi, kdspApi } = config;
const headers = {
  'Content-Type': 'application/x-www-form-urlencoded',
};

export async function searchList(params) {
  return request.post('/product/api/merchant/page', {
    prefix: goodsApi,
    data: stringify(params),
    headers,
    role: true,
  });
}

// 新增商品
export async function addGoods(params) {
  return request.post('/product/api/merchant/add', {
    prefix: goodsApi,
    data: params,
  });
}

// 编辑商品

export async function editGoods(params) {
  return request.post('/product/api/merchant/edit', {
    prefix: goodsApi,
    data: params,
  });
}

// 获取商品品牌
export async function getBrandList() {
  return request.post('/product/brand/api/merchant/list', {
    prefix: goodsApi,
  });
}

// 编辑--获取详情
export async function spuDetail(params) {
  return request.post('/product/api/merchant/detail', {
    prefix: goodsApi,
    params,
    headers,
  });
}

// 商品规格
export async function getSpecList() {
  return request.post('/product/spec/api/merchant/list', {
    prefix: goodsApi,
  });
}

// 查询图片素材
export async function getImageInfo(spuNo) {
  return request.post('/product/api/merchant/imageInfo', {
    params: { spuNo },
    prefix: goodsApi,
    headers,
  });
}

// 商品分类
export async function categoryList() {
  return request.post('/product/category/api/merchant/getAll', {
    prefix: goodsApi,
  });
}

// 批量修改
export async function uploadFile(file) {
  const params = new FormData();
  params.append('file', file);
  const data = await request.post('/product/api/merchant/BatchUpdateStock', {
    prefix: goodsApi,
    data: params,
    notTip: true,
  });
  return data;
}

// 商品修改日志
export async function changeLog(params) {
  return request.post('/product/logs/api/merchant/page', {
    data: stringify(params),
    prefix: goodsApi,
    headers,
  });
}

// 审核详情日志
export async function productMerchantLog(productId) {
  return request.get('/product/api/merchant/auditLog', {
    params: {
      productId,
    },
    prefix: goodsApi,
  });
}

// 拉去京东图片
export async function getJdPicList(params) {
  const { data } = await request.post('/product/api/merchant/item/getJdPicList', {
    data: stringify(params),
    prefix: goodsApi,
    headers,
  });
  return data;
}

// 图片上传
export async function uploadImg(files) {
  const params = new FormData();
  files.forEach(file => params.append('file', file));
  const data = await request.post('/image/api/merchant/upload', {
    prefix: goodsApi,
    data: params,
  });
  return data;
}

// 修改商品库存
export async function updateStock(params) {
  const data = await request.post('/product/item/api/merchant/updateStock', {
    prefix: goodsApi,
    data: stringify(params),
    headers,
  });
  if (data.businessCode === '0000') {
    return null;
  }
  return data.msg;
}

// 获取虚拟商品类目
export async function getVirtualCategory() {
  const data = await request.post('/product/category/api/merchant/getByParentId', {
    prefix: goodsApi,
    data: stringify({ id: 100018 }),
    headers,
  });
  return data;
}

// 查询商品属性列表
export async function specList() {
  return request.get('/product/api/merchant/spec', {
    prefix: goodsApi,
  });
}
// sku绑定模板
export async function getTemplate(params) {
  const data = await request.post('/api/kdsp/sku/template', {
    data: params,
    prefix: goodsApi,
  });
  return data;
}

// 不配送区域模板列表
export async function getTemplateList(params) {
  const data = await request.post('/api/kdsp/template/list', {
    data: stringify(params),
    prefix: goodsApi,
    headers,
  });
  return data;
}
// 查询供应商售后地址
export async function queryAllAfterAddress() {
  const params = {
    pageSize: 100,
    pageNo: 1,
  };
  const data = request.post('/api/kdsp/supplier/after-sales-addrs-page', {
    prefix: kdspApi,
    data: params,
  });
  return data;
}

// 商品售后地址设置
export async function getAfterAddress(params) {
  const data = await request.post('/product/api/updateSkuAfterAddress', {
    data: params,
    prefix: goodsApi,
  });
  return data;
}
