import { Form } from '@ant-design/compatible';
import '@ant-design/compatible/assets/index.css';
import { Modal, InputNumber, notification, Input, Radio } from 'antd';
import React from 'react';
import { updateStock } from '../service';

const UpdateStock = props => {
  const { getFieldDecorator, validateFields, resetFields, getFieldValue } = props.form;
  const valueInfo = props.info;
  getFieldDecorator('stockChangeType', { initialValue: 1 });
  const submit = async () => {
    validateFields(async (err, { stock, changeReason, stockChangeType }) => {
      if (err) return;
      const error = await updateStock({
        stock,
        id: valueInfo.id,
        supplierId: valueInfo.supplierId,
        stockChangeType,
        changeReason,
      });
      if (!error) {
        notification.success({ message: '操作成功！' });
        props.onCancel('success');
        resetFields();
      }
    });
  };
  const onCancel = () => {
    props.onCancel();
    resetFields();
  };
  const formItemLayout = {
    labelCol: {
      span: 8,
    },
    wrapperCol: {
      span: 16,
    },
  };

  const validatorCallback = (rule, value, callback) => {
    // 减库存存时，校验可售库存-输入值>=0,即可售库存不可为负；
    const stockChangeType = getFieldValue('stockChangeType');
    const increment = valueInfo.marketableStock - value;
    return !stockChangeType && increment < 0 ? callback(new Error(rule.message)) : callback();
  };

  return (
    <Modal title="修改库存" visible={props.visible} onCancel={onCancel} onOk={submit} width={400}>
      <Form {...formItemLayout}>
        <Form.Item label="变更类型:">
          {getFieldDecorator('stockChangeType', {
            rules: [{ required: true, message: '请选择类型!' }],
          })(
            <Radio.Group>
              <Radio value={1}>增库存</Radio>
              <Radio value={0}>减库存</Radio>
            </Radio.Group>,
          )}
        </Form.Item>
        <Form.Item label="库存数:">
          {getFieldDecorator('stock', {
            rules: [
              { required: true, message: '请输入库存!' },
              { validator: validatorCallback, message: '减库存,输入库存数不可大于可售库存！' },
            ],
            validateTrigger: ['onSubmit'],
          })(<InputNumber min={0} precision={0} placeholder="请输入库存" style={{ width: 200 }} />)}
        </Form.Item>
        <Form.Item label="变更原因:">
          {getFieldDecorator('changeReason', {
            rules: [{ required: true, message: '请输入变更原因!' }],
            initialValue: valueInfo.changeReason,
          })(<Input.TextArea />)}
        </Form.Item>
      </Form>
    </Modal>
  );
};

export default Form.create()(UpdateStock);
