import request from '@/utils/request';
import config from '../../config/env.config';

const { msgApi, wsApi } = config;

export const getSocketUrl = ({ token, channelId }) =>
  `${wsApi}/ws?token=${token}&channelId=${channelId}`;

/**
 * @name 商户消息列表
 * @see /yapi/project/193/interface/api/41792
 */
export function apiGetBussinessMsgList(data, params) {
  return request.post('/v1/send/message/getBussinessMsgList', {
    data,
    params,
    prefix: msgApi,
  });
}

/**
 * @name 获取未读消息数量
 * @see /yapi/project/193/interface/api/42792
 */
export function apiGetBusinessMsgUnReadCount(data) {
  return request.post('/v1/send/message/getBusinessMsgUnReadCount', {
    data,
    prefix: msgApi,
  });
}

/**
 * @name 设置消息为已读
 * @see /yapi/project/193/interface/api/41808
 */
export function apiUpdageBusinessMsgStatus(data) {
  return request.post('/v1/send/message/updateBussinessMsgReadStatus', {
    data,
    prefix: msgApi,
  });
}
