import React, { useState, useRef } from 'react';
import { ProTable } from '@ant-design/pro-components';
import { Button } from 'antd';
import { PlusOutlined } from '@ant-design/icons';
import { apiBrandList } from './services';
import { brandColumn } from './staticData.js';
import utilStyle from '@/utils/utils.less';
import BrandInfo from './components/BrandInfo.jsx';

// 品牌管理
const BrandManage = () => {
  const refTable = useRef();
  const [id, setId] = useState('');
  const [visible, setVisible] = useState(false);
  const [actionStatus, setActionStatus] = useState('add');

  // 编辑品牌
  const onAction = (record, status) => {
    setId(record.brandId);
    setActionStatus(status);
    setVisible(!0);
  };

  const onClose = refresh => {
    setVisible(false);
    refresh && refTable.current.reload();
  };

  return (
    <>
      <ProTable
        actionRef={refTable}
        search={{
          collapsed: false,
          span: 8,
          className: utilStyle.formSearch,
          collapseRender: () => null,
        }}
        columns={brandColumn({
          refTable,
          onAction,
        })}
        request={apiBrandList}
        toolBarRender={() => [
          <Button
            key="add"
            icon={<PlusOutlined />}
            type="primary"
            onClick={() => {
              setId('');
              setActionStatus('add');
              setVisible(!0);
            }}
          >
            添加
          </Button>,
        ]}
        rowKey={r => r.brandId}
        bordered
        options={false}
      />
      <BrandInfo
        visible={visible}
        actionStatus={actionStatus}
        brandId={id}
        onClose={onClose}
        id={id}
      />
    </>
  );
};

export default BrandManage;
