import React from 'react';
import { BetaSchemaForm } from '@ant-design/pro-components';
import { brandInfoColumn } from '../staticData.js';
import { layout } from '@/utils/bll';
import { apiBrandDetail, apiCreateBrand, apiEditBrand, apiAppendQualifyBrand } from '../services';
import { transformVOToFormData, transformFormDataToDTO } from '../bll.js';

const BrandInfo = props => {
  const refForm = React.useRef();
  const { actionStatus, brandId } = props;
  const closeModal = v => {
    !v && props.onClose(false);
  };
  const getAPI = () => {
    switch (actionStatus) {
      case 'edit':
        return apiEditBrand;
      case 'supplement':
        return apiAppendQualifyBrand;
      default:
        return apiCreateBrand;
    }
  };
  const submitForm = async values => {
    const params = transformFormDataToDTO(values);
    params.brandId = brandId;
    params.id = brandId;
    const api = getAPI();
    const res = api(params);
    if (res) {
      props.onClose(true);
    }
  };

  const getInfo = async () => {
    if (brandId) {
      const res = await apiBrandDetail({ brandId });
      if (res?.data) {
        return transformVOToFormData(res.data);
      }
    }
    return {};
  };

  const config = { actionStatus };

  return (
    <BetaSchemaForm
      layoutType="ModalForm"
      title="品牌信息"
      open={props.visible}
      width="600px"
      modalProps={{
        maskClosable: false,
        destroyOnClose: true,
      }}
      request={getInfo}
      formRef={refForm}
      onOpenChange={closeModal}
      layout="horizontal"
      {...layout}
      onFinish={submitForm}
      columns={brandInfoColumn(config)}
    />
  );
};

export default BrandInfo;
