import { Button, Tag, Popover } from 'antd';
import React from 'react';
import styles from './index.less';

export function columns(res) {
  return [
    {
      title: 'ID',
      dataIndex: 'id',
      key: 'id',
      width: 80,
      align: 'center',
    },
    {
      title: '名称',
      dataIndex: 'templateName',
      width: 200,
      key: 'templateName',
      align: 'center',
    },
    {
      title: '地址',
      dataIndex: 'areaNameList',
      key: 'areaNameList',
      align: 'center',
      width: 500,
      render: (_, row) => {
        const data = row.areaNameList?.join(',');
        const content = <p className={styles.content}>{data}</p>;
        return (
          <Popover content={content} title="不支持配送区域" trigger="hover">
            <p className={styles.p}>{data}</p>
          </Popover>
        );
      },
    },
    {
      title: '操作',
      dataIndex: 'option',
      valueType: 'option',
      key: 'option',
      align: 'center',
      width: 100,
      render: (_, row) => (
        <div className={styles.option}>
          <Button type="primary" onClick={() => res.edit(0, row)}>
            复制
          </Button>
          <Button type="primary" onClick={() => res.edit(1, row)}>
            编辑
          </Button>
        </div>
      ),
    },
  ];
}
