import request from '@/utils/request';
import config from '../../../config/env.config';
import { stringify } from 'qs';
import _ from 'lodash';

const { goodsApi, kdspApi } = config;
const headers = {
  'Content-Type': 'application/x-www-form-urlencoded',
};

export const merchantUpload = async files => {
  const params = new FormData();
  files.forEach(file => params.append('file', file));
  const data = await request.post('/image/api/merchant/upload', {
    prefix: goodsApi,
    data: params,
  });
  return data;
};

export const getProductDetail = id =>
  request.post('/product/api/merchant/detail', {
    prefix: goodsApi,
    params: { id },
    headers,
  });

export const merchantCategoryGetAll = () =>
  request.post('/product/category/api/merchant/getAll', {
    prefix: goodsApi,
  });

// 获取商品品牌
export const merchantBrandList = () =>
  request.post('/product/brand/api/merchant/list', {
    prefix: goodsApi,
  });

// 获取规格列表
export const merchantSpecList = () =>
  request.post('/product/spec/api/merchant/list', {
    prefix: goodsApi,
  });

// 查询供应商售后地址
export const afterSalesAddrsPage = () => {
  const params = {
    pageSize: 100,
    pageNo: 1,
  };
  const data = request.post('/api/merchants/aftersales/addresses/list', {
    prefix: kdspApi,
    data: stringify(_.omitBy(params, v => !v)),
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  return data;
};

export const merchantgetJdPicList = async params => {
  const { data } = await request.post('/product/api/merchant/item/getJdPicList', {
    data: stringify(params),
    prefix: goodsApi,
    headers,
  });
  return data;
};

export const merchantProductAdd = data =>
  request.post('/product/api/merchant/add', {
    prefix: goodsApi,
    data,
  });

export const merchantProductEdit = data =>
  request.post('/product/api/merchant/edit', {
    prefix: goodsApi,
    data,
  });

export const supplierListQuery = () =>
  request.get('/api/merchants/suppliers/querylist', {
    prefix: config.kdspApi,
    headers,
  });

// supplierId: 供应商id(优先使用token中的supplierId,这里可以传任意值，建议传0)
// state: 状态:-1-全部，1-启用，0-禁用
export const shopGetBySupplierId = (state = 1, supplierId = 0) =>
  request.get(`/shop/getBySupplierId/${supplierId}/${state}`, {
    prefix: goodsApi,
    headers,
  });
export const getByProductType = type =>
  request.get(`/product/category/getByProductType/${type}`, {
    prefix: goodsApi,
    headers,
  });

// 获取类目关联属性
export const apiGetAttribute = categoryId =>
  request.get(`/api/kdsp/category/template/ref/attribute/detail?categoryId=${categoryId}`, {
    prefix: goodsApi,
  });

// 新建草稿
export const apiCreateDraft = data =>
  request.post('/api/merchants/drafts/add', {
    prefix: goodsApi,
    data,
  });

// 编辑草稿
export const apiEditDraft = data =>
  request.post('/api/merchants/drafts/edit', {
    prefix: goodsApi,
    data,
  });
