/* eslint-disable no-console */
import * as Sentry from '@sentry/react';
import localStorage from '@/utils/localStorage';
// process.env.SENTRY_ENV !== 'test'  去掉测试环境不会报错

if (process.env.NODE_ENV === 'production') {
  try {
    Sentry.init({
      dsn: 'https://b3f60c62e1234e26a5b851b9f26fba07@sentry.q-gp.com/34',
      release: 'merchant-manage-ui@1.0.0',
      maxBreadcrumbs: 50,
      tracesSampleRate: 1,
      beforeSend: e => {
        const err = e.exception?.values || [];
        // XXX 12-21 不上报[object Object]此类基础库异常
        if (err.some(item => item.value.indexOf('“ResizeObserver') > -1)) {
          return null;
        }
        return e;
      },
    });
    Sentry.configureScope(scope => {
      scope.setUser({
        token: localStorage.get('token') || null,
      });
    });
  } catch (e) {
    console.log('Sentry无法加载', e);
  }
}

export const dva = {
  config: {
    onError(e) {
      e.preventDefault();
      console.error(e.message);
    },
  },
};
