import React, { useRef, useState, useEffect } from 'react';
import {
  Input,
  Checkbox,
  Radio,
  Button,
  notification,
  Spin,
  Select,
  Row,
  Col,
  Form,
  Table,
} from 'antd';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import { GoodsInfoColumn } from './staticData/goods';
import SaleDateModal from './components/SaleDateModal';
import SaleSectionModal from './components/SaleSectionModal';
import SelectGoodsModal from './components/SelectGoodsModal';

import style from './style/index.less';

const TakeawayGoodsInfo = props => {
  const { id } = props.location.query;
  const [loading, setLoading] = useState(false);
  const [visibleSaleDate, setVisibleSaleDate] = useState(false); // 可售日期弹窗
  const [visibleSaleSection, setVisibleSaleSection] = useState(true); // 可售餐段弹窗
  const [visibleSelectGoods, setVisibleSelectGoods] = useState(true); // 选择商品弹窗
  const [dataSource, setDataSource] = useState([]);

  // 提交
  // const onSubmit = () => {
  // };

  // 提交
  const onDel = () => {};

  // const initData = async () => {
  //   setLoading(true);
  // };
  // useEffect(() => {
  //   initData();
  // }, []);

  const options = {
    setVisibleSaleDate,
    setVisibleSaleSection,
    onDel,
  };

  return (
    <PageHeaderWrapper title="添加企业严选商品">
      <div className={style['info-box']}>
        <Spin spinning={loading}>
          <Row className={style['info-box--line']}>
            <Col span={3} className={style['info-box--label']}>
              企业名称：
            </Col>
            <Col span={20}>企业名称111</Col>
          </Row>
          <Row className={style['info-box--line']}>
            <Col span={3} className={style['info-box--label']}>
              选择店铺：
            </Col>
            <Col span={20}>
              <Select className={style['info-box--select']} placeholder="清选择" />
            </Col>
          </Row>
          <Row className={style['info-box--line']}>
            <Col span={3} className={style['info-box--label']}>
              添加商品：
            </Col>
            <Col span={20}>
              <Button type="primary" onClick={() => setVisibleSelectGoods(true)}>
                选择商品
              </Button>
            </Col>
          </Row>
          <Row className={style['info-box--line']}>
            <Col span={24}>
              <Table columns={GoodsInfoColumn(options)} dataSource={dataSource} />
            </Col>
          </Row>
          <Row className={style['info-box--btns']}>
            <Col span={4} />
            <Col span={20}>
              <Button type="primary" className={style['info-box--btns__confirm']}>
                确定
              </Button>
              <Button>取消</Button>
            </Col>
          </Row>
        </Spin>
        {/* 可售日期弹窗 */}
        {visibleSaleDate && (
          <SaleDateModal visible={visibleSaleDate} handleClose={() => setVisibleSaleDate(false)} />
        )}
        {/* 可售餐段弹窗 */}
        {visibleSaleSection && (
          <SaleSectionModal
            visible={visibleSaleSection}
            handleClose={() => setVisibleSaleSection(false)}
          />
        )}
        {/* 选择商品弹窗 */}
        {visibleSelectGoods && (
          <SelectGoodsModal
            visible={visibleSelectGoods}
            handleClose={() => setVisibleSelectGoods(false)}
          />
        )}
      </div>
    </PageHeaderWrapper>
  );
};

export default TakeawayGoodsInfo;
