import React, { useState } from 'react';
import { Form, InputNumber, Modal } from 'antd';
import { ExclamationCircleOutlined } from '@ant-design/icons';
import { jsonToArray } from '@/utils/utils';
import { layout } from '../staticData/goods';
import { isCheckPriceTwoDecimal } from '@/utils/validator';

const SaleDateModal = props => {
  const [form] = Form.useForm();
  const [value, setValue] = useState(1);

  // 关闭弹窗
  const handleCancel = () => {
    props.handleClose(false);
  };

  const onChangeWeek = e => {
    setValue(e.target.value);
  };

  // 提交
  const handleConfirm = async () => {
    const res = await form.validateFields();
    console.log('res :>> ', res);
  };

  return (
    <Modal
      title="修改商品排序"
      open={props.visible}
      destroyOnClose
      maskClosable={false}
      width="300px"
      onOk={handleConfirm}
      onCancel={handleCancel}
    >
      <Form name="basicInfo" initialValues={{ sort: 1000 }} {...layout} form={form}>
        <Form.Item label="排序" name="sort" rules={[{ required: true, message: '请输入排序!' }]}>
          <InputNumber max={999999} min={1} />
        </Form.Item>
      </Form>
    </Modal>
  );
};
export default SaleDateModal;
