import React, { useState } from 'react';
import { Form, InputNumber, Modal } from 'antd';
import { layout } from '../staticData/goods';
import { isCheckPriceTwoDecimal } from '@/utils/validator';

const SaleDateModal = props => {
  const [form] = Form.useForm();

  // 关闭弹窗
  const handleCancel = () => {
    props.handleClose(false);
  };

  // 提交
  const handleConfirm = async () => {
    const res = await form.validateFields();
    console.log('res :>> ', res);
  };

  return (
    <Modal
      title="修改企业商品价格"
      open={props.visible}
      destroyOnClose
      maskClosable={false}
      width="300px"
      onOk={handleConfirm}
      onCancel={handleCancel}
    >
      <Form name="basicInfo" {...layout} form={form}>
        <Form.Item
          label="企业商品价格"
          name="types"
          rules={[
            { required: true, message: '请输入企业商品价格!' },
            { validator: isCheckPriceTwoDecimal, message: '请输入正确的价格' },
          ]}
        >
          <InputNumber addonAfter="元" max={99999.99} />
        </Form.Item>
      </Form>
    </Modal>
  );
};
export default SaleDateModal;
