import React, { useState, useRef } from 'react';
import ProTable from '@ant-design/pro-table';
import { Button } from 'antd';
import { PlusOutlined } from '@ant-design/icons';
import { customerColumn } from './staticData/index';
import CustomerInfo from './components/CustomerInfo';
import { apiEnterpriseList } from './service';

const BusinessCustomer = () => {
  const [visible, setVisible] = useState(false);
  const query = async params => {
    const data = {
      page: params.current,
      size: params.pageSize,
      data: params,
    };
    return apiEnterpriseList(data);
  };
  const onEdit = async () => {};

  return (
    <div>
      <ProTable
        search={{
          collapsed: false,
          collapseRender: () => null,
        }}
        columns={customerColumn({ onEdit })}
        request={params => query({ ...params })}
        rowKey={r => r.id}
        expandIconColumnIndex={10}
        bordered
        options={false}
        toolBarRender={() => [
          <Button key="3" icon={<PlusOutlined />} type="primary" onClick={() => setVisible(!0)}>
            添加企业客户
          </Button>,
        ]}
        scroll={{ x: '100%', y: 400 }}
      />
      <CustomerInfo visible={visible} handleClose={setVisible} />
    </div>
  );
};

export default BusinessCustomer;
