import React, { useState, useRef } from 'react';
import { useHistory } from 'react-router-dom';
import { ProTable } from '@ant-design/pro-components';
import { Button, Space } from 'antd';
import { PlusOutlined } from '@ant-design/icons';
import { takeawayGoodsColumn } from './staticData/goods';
import utilStyle from '@/utils/utils.less';
import { apiTakeawayList } from './service/api';
import SaleDateModal from './components/SaleDateModal';
import SaleSectionModal from './components/SaleSectionModal';
import GoodPriceModal from './components/GoodPriceModal';
import GoodSortModal from './components/GoodSortModal';
import { getToUrlQuery } from '@/utils/utils';

const BusinessCustomer = () => {
  const history = useHistory();
  const [visibleSaleDate, setVisibleSaleDate] = useState(false); // 可售日期弹窗
  const [visibleSaleSection, setVisibleSaleSection] = useState(false); // 可售餐段弹窗
  const [visiblePrice, setVisiblePrice] = useState(false); // 修改企业商品价格弹窗
  const [visibleSort, setVisibleSort] = useState(false); // 商品排序弹窗
  const [visibleGoods, setVisibleGoods] = useState(false); // 添加外卖商品弹窗
  const [activeKey, setActiveKey] = useState('tab1');
  const searchList = async params => {
    const data = {
      page: params.current,
      size: params.pageSize,
      data: params,
    };
    // return apiTakeawayList(data);
  };
  const onDel = async () => {};
  const onAdd = async () => {
    const query = getToUrlQuery();
    history.push({
      pathname: '/takeawayGoodsInfo',
      query,
    });
  };
  const options = {
    setVisibleSaleDate,
    setVisibleSaleSection,
    setVisiblePrice,
    setVisibleSort,
    setVisibleGoods,
    onDel,
  };

  return (
    <div>
      <ProTable
        search={{
          span: 6,
          className: utilStyle.formSearch,
          collapsed: false,
          collapseRender: () => null,
        }}
        tableClassName={utilStyle.formTable}
        columns={takeawayGoodsColumn(options)}
        request={params => searchList({ ...params })}
        rowKey={r => r.id}
        expandIconColumnIndex={10}
        bordered
        options={false}
        toolbar={{
          menu: {
            type: 'tab',
            activeKey,
            items: [
              {
                key: 'tab1',
                label: <span>取餐点1</span>,
              },
              {
                key: 'tab2',
                label: <span>取餐点2</span>,
              },
              {
                key: 'tab3',
                label: <span>取餐点3</span>,
              },
            ],
            onChange: key => {
              setActiveKey(key);
            },
          },
          actions: [
            <Button key="1" icon={<PlusOutlined />} type="primary" onClick={onAdd}>
              添加外卖商品
            </Button>,
          ],
        }}
        scroll={{ x: '100%', y: 400 }}
      />
      {/* 可售日期弹窗 */}
      {visibleSaleDate && (
        <SaleDateModal visible={visibleSaleDate} handleClose={() => setVisibleSaleDate(false)} />
      )}
      {/* 可售餐段弹窗 */}
      {visibleSaleSection && (
        <SaleSectionModal
          visible={visibleSaleSection}
          handleClose={() => setVisibleSaleSection(false)}
        />
      )}
      {/* 修改企业商品价格弹窗 */}
      {visiblePrice && (
        <GoodPriceModal visible={visiblePrice} handleClose={() => setVisiblePrice(false)} />
      )}
      {/* 商品排序弹窗 */}
      {visibleSort && (
        <GoodSortModal visible={visibleSort} handleClose={() => setVisibleSort(false)} />
      )}
    </div>
  );
};

export default BusinessCustomer;
