import React, { useState, useRef, useEffect, useCallback, useMemo } from 'react';
import { Spin, Button, Modal, message, notification, Tag } from 'antd';
import { PlusOutlined, HolderOutlined, FormOutlined, CloseCircleOutlined } from '@ant-design/icons';
import { DndProvider } from 'react-dnd';
import HTML5Backend from 'react-dnd-html5-backend';
import styles from '../style.less';
import DragTag from './components/DragTag';
import InsertTag from './components/InsertTag';

const Takeaway = options => {
  const [groupEdit, setGroupEdit] = useState(false);
  const [selected, setSelected] = useState(0);

  const [tags, setTags] = useState([
    {
      id: 0,
      text: '000',
    },
    {
      id: 1,
      text: '111',
    },
  ]);

  const changePosition = (dragIndex, hoverIndex) => {
    const data = tags.slice();
    const temp = data[dragIndex];
    // 交换位置
    data[dragIndex] = data[hoverIndex];
    data[hoverIndex] = temp;
    setTags(data);
  };

  return (
    <div className={styles.takeawayBox}>
      <div className={styles.groupBox}>
        <div className={styles['groupBox-title']}>
          <div>商品分组</div>
          <Button className={styles['groupBox-btn']} onClick={() => setGroupEdit(!groupEdit)}>
            {groupEdit ? '完成' : '编辑分组'}
          </Button>
        </div>
        <div className={styles['groupBox-body']}>
          {groupEdit ? (
            <DndProvider backend={HTML5Backend}>
              <div className={styles['groupBox-body--dragbox']}>
                {tags.map((item, index) => (
                  <DragTag
                    changePosition={changePosition}
                    index={index}
                    {...item}
                    selected={selected}
                    changeGroup={e => setSelected(e)}
                    key={item.id}
                  />
                ))}
                <InsertTag />
              </div>
            </DndProvider>
          ) : (
            <div className={styles['groupBox-body--dragbox']}>
              {tags.map((item, index) => (
                <Tag
                  onClick={() => setSelected(index)}
                  className={[
                    styles['groupBox-body--tag-normal'],
                    selected === index ? styles['groupBox-body--tag__cur'] : '',
                  ]}
                >
                  <span>{item.text}</span>
                </Tag>
              ))}
              <InsertTag />
            </div>
          )}
        </div>
      </div>
    </div>
  );
};

export default Takeaway;
