import { stringify } from 'querystring';
import request from '@/utils/request';
import _ from 'lodash';
import config from '../../../config/env.config';

const { goodsApi } = config;

// 分页查询所有数据
export async function searchList(params) {
  const param = {
    pageNo: params.current || 1,
    pageSize: params.pageSize || 20,
  };
  const data = await request.post('/api/kdsp/template/page', {
    prefix: goodsApi,
    data: stringify(_.omitBy(param, v => !v)),
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  if (data.data) {
    return {
      total: data.data.total,
      data: data.data.forbiddenAreaTemplateList,
    };
  }
  return {
    total: 0,
    data: [],
  };
}
// 添加区域受限模板
export async function getAddTemplate(param) {
  const data = await request.post('/api/kdsp/add/template', {
    prefix: goodsApi,
    data: param,
  });
  return data;
}

// 获取区域地址
export async function areaList(params) {
  const { data } = await request.get('/api/kdsp/area/addr/query', {
    prefix: goodsApi,
    params,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  return data;
}

// 根据模板id查询受限区域
export async function forbiddenAddress(params) {
  const data = await request.post('/api/kdsp/edit/template', {
    prefix: goodsApi,
    data: params,
  });
  return data;
}

// 根据模板id查询受限区域
export async function addressTree(params) {
  const data = await request.post('/api/kdsp/forbidden/address', {
    prefix: goodsApi,
    params,
  });
  return data;
}
