import React, { useState, useRef, useEffect, useCallback, useMemo } from 'react';
import { Spin, Table, Modal, message, notification } from 'antd';
import { MenuOutlined, HolderOutlined, FormOutlined, CloseCircleOutlined } from '@ant-design/icons';
import { SortableContainer, SortableElement, SortableHandle } from 'react-sortable-hoc';
import { arrayMoveImmutable } from 'array-move';
import GoodsGroup from './components/GoodsGroup';
import { searchList } from '../service';
import styles from '../style.less';
import { takeawayColumn } from '../staticdata';

const Takeaway = options => {
  const actionRef = useRef(null);
  const [tableData, setTableData] = useState([]);
  const [loading, setLoading] = useState(false);
  const rowSelection = {};
  const DragHandle = SortableHandle(() => (
    <MenuOutlined style={{ cursor: 'grab', color: '#999' }} />
  ));

  const onSortEnd = ({ oldIndex, newIndex }) => {
    if (oldIndex !== newIndex) {
      const newData = arrayMoveImmutable(tableData.slice(), oldIndex, newIndex).filter(el => !!el);
      setTableData(newData);
    }
  };

  const SortableItem = SortableElement(props => <tr {...props} />);
  const SortableBody = SortableContainer(props => <tbody {...props} />);

  const DraggableContainer = props => (
    <SortableBody
      useDragHandle
      disableAutoscroll
      helperClass={styles['row-dragging']}
      onSortEnd={onSortEnd}
      {...props}
    />
  );

  const getDataList = async () => {
    setLoading(true);
    const res = await searchList({ productType: 1 });
    setLoading(false);
    if (res && res.data) {
      setTableData(res.data.records);
    }
  };

  const DraggableBodyRow = ({ className, style, ...restProps }) => {
    // function findIndex base on Table rowKey props and should always be a right array index
    const index = tableData.findIndex(x => x.skuId === restProps['data-row-key']);
    return <SortableItem index={index} {...restProps} />;
  };

  useEffect(() => {
    getDataList();
  }, []);

  return (
    <div className={styles.takeawayBox}>
      <Spin spinning={loading}>
        <GoodsGroup />
        <Table
          dataSource={tableData}
          bordered
          columns={takeawayColumn.call(this)}
          rowKey={record => record.skuId}
          pagination={false}
          // scroll={{ x: '100%', y: 500 }}
          // rowSelection={rowSelection}
          components={{
            body: {
              wrapper: DraggableContainer,
              row: DraggableBodyRow,
            },
          }}
        />
      </Spin>
    </div>
  );
};

export default Takeaway;
