import { Button, Divider, Dropdown, Icon, Menu, message, Table } from 'antd';
import React, { useState, useEffect, useRef } from 'react';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import ProTable from '@ant-design/pro-table';
import LogisticsForm from './components/LogisticsForm';
import OrderDetail from './components/OrderDetail';
import { queryToSend, queryExpress, getGoods } from './service';

const TableList = () => {
  const [companys, setCompanys] = useState([]);
  const [LogisticsModalVisible, handleModalVisible] = useState(false);
  const [detailModalVisible, handleDetailModalVisible] = useState(false);
  const [skuList, setSkuList] = useState([]);
  const actionRef = useRef();
  const columns = [
    {
      title: '订单ID',
      dataIndex: 'orderNo',
      key: 'orderNo',
      order: 6,
    },
    {
      title: '商品渠道',
      dataIndex: 'skuSource.desc',
      key: 'skuSource.desc',
      hideInSearch: true,
    },
    {
      title: '交易时间',
      dataIndex: 'orderTime',
      key: 'orderTime',
      hideInSearch: true,
    },
    {
      title: '收货人手机',
      dataIndex: 'receiverPhone',
      key: 'receiverPhone',
      order: 4,
    },
    {
      title: '收货人姓名',
      dataIndex: 'receiverName',
      key: 'receiverName',
      order: 3,
    },
    {
      title: '收货地址',
      dataIndex: 'fullAddress',
      key: 'fullAddress',
      hideInSearch: true,
      width: 160,
    },
    {
      title: '物流状态',
      dataIndex: 'logisticsStatus',
      key: 'logisticsStatus',
      filters: false,
      valueEnum: {
        '_3': '全部',
        '_1': '未发货',
        '_2': '已发货',
      },
      order: 5,
    },
    {
      title: '订单开始时间',
      dataIndex: 'beginTime',
      key: 'beginTime',
      valueType: 'date',
      hideInTable: true,
    },
    {
      title: '订单结束时间',
      dataIndex: 'endTime',
      key: 'endTime',
      valueType: 'date',
      hideInTable: true,
    },
    {
      title: '操作',
      dataIndex: 'option',
      key: 'option',
      valueType: 'option',
      width: 120,
      render: (_, record) => (
        <React.Fragment>
          {
            record.skuSource.value !== 2 && record.logisticsStatus === '_1' ? (
                <Button
                  type="primary"
                  style={
                    {
                      marginBottom: '10px',
                    }
                  }
                  onClick={async () => {
                    const skuList = await getGoods(record.orderId);
                    setSkuList(skuList);
                    handleModalVisible(true);
                  }}
                >
                  更新物流信息
                </Button>
            ) : null
          }
          <Button 
            type="primary" 
            onClick={async () => {
              const skuList = await getGoods(record.orderId);
              console.log('skuList', skuList);
              setSkuList(skuList);
              handleDetailModalVisible(true);
            }}>查看订单详情</Button>
        </React.Fragment>
      ),
    },
  ];

  const reload = () => {
    handleModalVisible(false)
    if (actionRef.current) {
      actionRef.current.reload();
    }
  };

  useEffect(() => {
    const getCompanys = async () => {
      const data = await queryExpress();
      setCompanys(data);
    };
    getCompanys();
  }, []);

  return (
    <PageHeaderWrapper>
      <ProTable
        actionRef={actionRef}
        request={(params, sorter, filter) => queryToSend({ ...params })}
        columns={columns}
        search={{ collapsed: false, collapseRender: () => null }}
      />
      <LogisticsForm onSubmit={reload} skuList={skuList} companys={companys} onCancel={() => handleModalVisible(false)} modalVisible={LogisticsModalVisible} />
      <OrderDetail value={skuList} onCancel={() => handleDetailModalVisible(false)} modalVisible={detailModalVisible} />
    </PageHeaderWrapper>
  )
};

export default TableList;
