import * as api from './service';

const Model = {
  namespace: 'popGoodsManage',
  state: {
    tableData: {},
    shopList: [],
    statusList: [],
    cid1List: [],
    cid2List: [],
    cid3List: [],
    treeData: [],
  },
  effects: {
    *getList({ payload }, { call, put }) {
      const params = payload;
      const productCategoryId = payload?.productCategoryId || [];
      params.productCategoryId =
        (productCategoryId.length && productCategoryId[productCategoryId.length - 1]) || '';
      const res = yield call(api.searchList, params);
      if (res && !res.data) return;
      yield put({
        type: 'saveData',
        payload: {
          tableData: res.data,
        },
      });
    },
    *categoryList({ payload }, { call, put }) {
      const [data] = yield call(api.categoryList, payload.value);
      if (!data) return;
      yield put({
        type: 'saveCategory',
        payload: {
          [payload.categoryNum]: data,
        },
      });
    },
  },
  reducers: {
    saveData(state, action) {
      const data = action.payload;
      return { ...state, ...data };
    },
    dataList(state, action) {
      const data = action.payload;
      return { ...state, ...data };
    },
    saveCategory(state, action) {
      const data = action.payload;
      return { ...state, ...data };
    },
  },
};
export default Model;
