import { stringify } from 'querystring';
import _ from 'lodash';
import request from '@/utils/request';
import config from '../../../config/env.config';

// 查询
export async function query(params) {
  const tempParams = {
    ...params,
    pageNo: params.current,
  };
  delete tempParams.current;

  try {
    const {
      data: { current, records, total, size },
    } = await request.post('/api/merchants/aftersales/addresses/list', {
      prefix: config.kdspApi,
      data: stringify(_.omitBy(tempParams, v => !v)),
      headers: {
        'Content-Type': 'application/x-www-form-urlencoded',
      },
    });
    return {
      current,
      data: records.map(v => ({ ...v, logisticsStatus: `_${v.logisticsStatus}` })),
      total,
      pageSize: size,
    };
  } catch (error) {
    return {};
  }
}
export async function supplier() {
  const { data } = await request.get('/api/merchants/suppliers/list', {
    prefix: config.kdspApi,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  return data;
}

export async function del(id) {
  const data = await request.post('/api/merchants/aftersales/addresses/delete', {
    prefix: config.kdspApi,
    data: stringify({ id }),
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  return data;
}

export async function apiEdit(params) {
  const { businessCode } = await request.post('/api/merchants/aftersales/addresses/edit', {
    prefix: config.kdspApi,
    data: stringify(params),
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  return businessCode;
}
export async function apiAdd(params) {
  const { businessCode } = await request.post('/api/merchants/aftersales/addresses/add', {
    prefix: config.kdspApi,
    data: stringify(params),
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  return businessCode;
}

export async function addrQuery(params) {
  const { data } = await request.get('/api/merchants/addresses/list', {
    prefix: config.kdspApi,
    params,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  return data;
}
