import request from '@/utils/request';
import config from '../../../config/env.config';
import { stringify } from 'qs';
import _ from 'lodash';

const { kdspApi } = config;

// 分页查询所有数据
export const searchList = params =>
  request.post('/api/kdsp/op/afs/shop/list', {
    prefix: kdspApi,
    data: stringify(_.omitBy(params, v => !v && v !== 0)),
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });

// 售后单详情
export function orderDetail(params) {
  return request.get('/api/kdsp/op/afs/sku', {
    prefix: kdspApi,
    params,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
}

// 取消售后单详情
export async function cancelOrderDetail(params) {
  const data = await request.get('/cancel-order/sku', {
    prefix: kdspApi,
    params,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  return data.data || [];
}

// 售后审核
export async function shopAudit(params) {
  return request.post('/api/kdsp/op/afs/shop/audit', {
    data: params,
    prefix: kdspApi,
  });
}

// 取消订单审核
export async function cancelShopAudit(params) {
  return request.post('/cancel-order/audit', {
    data: params,
    prefix: kdspApi,
  });
}

// 查询审核信息
export async function auditInfoApi(params) {
  return request.get('/api/kdsp/op/afs/back-info', {
    params,
    prefix: kdspApi,
  });
}

// 审核核检
export async function shopCheck(params) {
  return request.post('/api/kdsp/op/afs/shop/check', {
    params,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
    prefix: kdspApi,
  });
}
// 查询物流信息
export async function trackInfo(params) {
  const data = await request.get('/api/merchants/deliveries/trace/list', {
    params,
    prefix: kdspApi,
  });
  if (data.businessCode === '0000') {
    return data.data;
  }
  return {};
}

// 物流拦截
export async function logisticsIntercept(params) {
  return request.get('/api/kdsp/op/afs/shop/logisticsIntercept', {
    params,
    prefix: kdspApi,
  });
}
// 售后操作日志
export async function getOpLog(params) {
  return request.get(`/afterSaleAdmin/getOpLog/${params}`, {
    prefix: kdspApi,
  });
}

/**
 * 多物流发货-查询物流轨迹
 * @see http://yapi.quantgroups.com/project/389/interface/api/46120
 */

export function apiDeliveriesTraceList(data) {
  return request.post('/api/merchants/deliveries/trace/list', {
    data: stringify(data),
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
    prefix: kdspApi,
  });
}

// 查询售后待办数量
export function getAfterPendingNum(data) {
  return request.post('/api/kdsp/op/afs/getPendingNum', {
    prefix: kdspApi,
    data,
  });
}

// 查询供应商售后地址
export const afterSalesAddrsPage = () => {
  const params = {
    pageSize: 100,
    pageNo: 1,
  };
  const data = request.post('/api/kdsp/supplier/after-sales-addrs-page', {
    prefix: kdspApi,
    data: stringify(_.omitBy(params, v => !v)),
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  return data;
};
