import React, { useState, useRef, forwardRef, useEffect } from 'react';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import { Modal, Form, Select, Table, Card, Row, Col, Input, Button, message, Upload } from 'antd';
import { columns, repastTypeList } from './data';
import styles from './index.less';
import { apiStaffList, apiEnterpriseList, apiDepartmentList, apiStaffExcel } from './service.js';
import NewEmployeeModal from './components/newEmployeeModal';
import DepartmentModal from './components/departmentModal';
import ViewDepartmentModal from './components/ViewDepartmentModal';

const { confirm } = Modal;
const StoreManagement = () => {
  const [modalVisible, setModalVisible] = useState(false);
  const [departmentVisible, setDepartmentVisible] = useState(false);
  const [viewDepartmentVisible, setViewDepartmentVisible] = useState(false);
  const [staffList, setStaffList] = useState([]);
  const [enterpriseList, setEnterpriseList] = useState([]);
  const [firstEnterprise, setFirstEnterprise] = useState();
  const [departmentList, setDepartmentList] = useState([]);
  const [page, setPage] = useState({
    page: 1,
    size: 10,
  });
  const [searchForm, setSearchForm] = useState({});
  const formRef = useRef(null);
  const [editVisible, setEditVisible] = useState(false);
  const [addVisible, setAddVisible] = useState(false);
  const [repastType, setRepastType] = useState([]);
  const [repastId, setRepastId] = useState(null);
  const data = [
    {
      enterpriseId: '企业id',
      id: '1',
      shopId: 'shopId',
      shopName: '店铺名称',
      mealType: '到店',
      pickselfName: '',
      updatedBy: '修改人名称',
      amount: '2023/03/21 14:06:11',
      isBlack: 0,
    },
    {
      enterpriseId: '企业id',
      id: '2',
      shopId: 'shopId',
      shopName: '店铺名称',
      mealType: '到店',
      pickselfName: '取餐点',
      updatedBy: '修改人名称',
      isBlack: 1,
    },
  ];

  const shopList = async () => {
    const res = await apiStaffList({ ...page, data: searchForm });
    if (res.businessCode === '0000' && res.data?.records?.length) {
      const list = res.data.records;
      setStaffList(list);
    }
  };
  // 上传文件
  const handleUpload = async info => {
    if (info.file.status === 'done') {
      console.log(info.file);
      const res = await apiStaffExcel(info.file);
      if (res.businessCode === '0000') {
        message.success('上传成功');
        shopList();
      }
    } else if (info.file.status === 'error') {
      console.log('File upload failed:', info.file.error);
    }
  };
  // 关闭弹框
  const handleCloseModal = val => {
    setModalVisible(false);
    setDepartmentVisible(false);
    setViewDepartmentVisible(false);
    if (val) {
      shopList();
    }
  };
  // 部门查询
  const getDepartmentList = async id => {
    const res = await apiDepartmentList({ id, page: 1, size: 10000 });
    if (res.businessCode === '0000' && res.data?.records?.length) {
      const list = res.data.records;
      const optionData = list.map(item => ({
        value: item.id,
        label: item.name,
      }));
      setDepartmentList(optionData);
      return;
    }
    setDepartmentList([]);
  };
  // 企业查询
  const getEnterpriseList = async () => {
    const res = await apiEnterpriseList();
    if (res.businessCode === '0000' && res.data?.records?.length) {
      const list = res.data.records;
      const firstOption = list[0].id;
      const optionData = list.map(item => ({
        value: item.id,
        label: item.name,
      }));
      setFirstEnterprise(firstOption);
      setEnterpriseList(optionData);
      getDepartmentList(firstOption);
      shopList();
    }
  };

  useEffect(() => {
    getEnterpriseList();
  }, []);

  const setMealTypeList = async () => {
    // const res = await mealTypeList({ id: repastId });
    // if (res.businessCode === '0000') {
    // setRepastType(res.data);
    setEditVisible(true);
    // }
  };
  // 修改餐饮类型
  const editRepastType = ({ id }) => {
    setRepastId(id);
    setMealTypeList();
  };
  // 删除
  const deleteShop = async id => {
    // const res = await setShopDelete({ id });
    // if (res.businessCode === '0000') {
    //   message.success('删除成功！');
    //   shopList();
    // }
  };
  // 删除
  const delShop = ({ staffName, id }) => {
    confirm({
      title: `确认删除企业员工#${staffName || ''}#?`,
      onOk() {
        deleteShop(id);
      },
      onCancel() {
        console.log('Cancel');
      },
    });
  };

  // 添加商户
  const addShop = () => {
    setAddVisible(true);
  };
  // 搜索
  const onFinish = values => {
    setSearchForm(values);
    setPage({ current: 1, pageSize: 10 });
    shopList();
  };
  // 重置
  const onReset = () => {
    formRef.current.resetFields();
    shopList();
  };
  // 分页
  const handleTableChange = val => {
    setPage(val);
  };

  const res = {
    editRepastType,
    delShop,
  };
  return (
    <PageHeaderWrapper>
      <Card className={styles.card}>
        <Form ref={formRef} onFinish={onFinish} initialValue={{ enterpriseId: firstEnterprise }}>
          <Row gutter={24}>
            <Col span={8}>
              <Form.Item
                label="企业名称"
                name="enterpriseId"
                wrapperCol={{ span: 16 }}
                rules={[{ required: true }]}
              >
                <Select
                  allowClear
                  showSearch
                  filterOption={(input, option) =>
                    (option?.label ?? '').toLowerCase().includes(input.toLowerCase())
                  }
                  options={enterpriseList}
                />
              </Form.Item>
            </Col>
            <Col span={8}>
              <Form.Item label="部门查询" name="departmentId" wrapperCol={{ span: 16 }}>
                <Select
                  allowClear
                  showSearch
                  filterOption={(input, option) =>
                    (option?.label ?? '').toLowerCase().includes(input.toLowerCase())
                  }
                  options={departmentList}
                />
              </Form.Item>
            </Col>
            <Col span={8}>
              <Form.Item label="员工手机号" name="mobile" wrapperCol={{ span: 16 }}>
                <Input maxLength="11" allowClear />
              </Form.Item>
            </Col>
            <Col span={8}>
              <Form.Item label="员工id" name="staffNo" wrapperCol={{ span: 16 }}>
                <Input allowClear />
              </Form.Item>
            </Col>
            <Col span={8}>
              <Form.Item label="员工状态" name="mealType" wrapperCol={{ span: 16 }}>
                <Select
                  allowClear
                  showSearch
                  filterOption={(input, option) =>
                    (option?.label ?? '').toLowerCase().includes(input.toLowerCase())
                  }
                  options={[
                    {
                      value: 0,
                      label: '正常',
                    },
                    {
                      value: 1,
                      label: '拉黑',
                    },
                  ]}
                  placeholder="全部"
                />
              </Form.Item>
            </Col>
            <Col span={8}>
              <Form.Item label="员工姓名" name="staffName" wrapperCol={{ span: 16 }}>
                <Input maxLength="8" allowClear />
              </Form.Item>
            </Col>
            <Col>
              <Form.Item>
                <Button type="primary" htmlType="submit">
                  搜索
                </Button>
                <Button htmlType="button" onClick={onReset} className={styles.left}>
                  重置
                </Button>
              </Form.Item>
            </Col>
          </Row>
        </Form>
        <div className={styles.addBtn}>
          <Upload onChange={handleUpload} accept=".xls,.xlsx" maxCount={1} showUploadList={false}>
            <Button type="primary">初始化数据上传Excel</Button>
          </Upload>
          <Button type="primary" className={styles.left}>
            设置员工黑名单
          </Button>
          <Button
            type="primary"
            className={styles.left}
            onClick={() => {
              setModalVisible(true);
            }}
          >
            添加新员工
          </Button>
          <Button
            type="primary"
            className={styles.left}
            onClick={() => {
              setDepartmentVisible(true);
            }}
          >
            创建部门
          </Button>
          <Button
            type="primary"
            className={styles.left}
            onClick={() => {
              setViewDepartmentVisible(true);
            }}
          >
            查看部门
          </Button>
        </div>
      </Card>
      <Table
        columns={columns(res)}
        dataSource={staffList}
        rowKey={r => r.appealNo}
        bordered
        onChange={handleTableChange}
      />
      <NewEmployeeModal
        visible={modalVisible}
        enterpriseList={enterpriseList}
        departmentList={departmentList}
        onClose={handleCloseModal}
        getDepartmentList={getDepartmentList}
      />
      <DepartmentModal
        visible={departmentVisible}
        enterpriseList={enterpriseList}
        onClose={handleCloseModal}
      />
      <ViewDepartmentModal
        visible={viewDepartmentVisible}
        enterpriseList={enterpriseList}
        onClose={handleCloseModal}
      />
    </PageHeaderWrapper>
  );
};
export default StoreManagement;
